/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 3, example 2.
 *
 *  This code shows how to create a robot out of various nodes.
 *  It introduces shared instancing of nodes to create two legs
 *  using two instances of the same subgraph.
 *
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoCylinder.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoTransform.h>

SoSeparator *
makeRobot()
{
  //////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE
  // Robot with legs
  
  // Construct parts for legs (thigh, calf and foot)
  SoCube *thigh = new SoCube;     
  thigh->width = 1.2f;
  thigh->height = 2.2f;
  thigh->depth = 1.1f;
  
  SoTransform *calfTransform = new SoTransform;
  calfTransform->translation.setValue(0.0f, -2.25f, 0.0f);
  
  SoCube *calf = new SoCube;
  calf->width = 1.0f;
  calf->height = 2.2f;
  calf->depth = 1.0f;
  
  SoTransform *footTransform = new SoTransform;
  footTransform->translation.setValue(0.0f, -1.5f, 0.5f);
  
  SoCube *foot = new SoCube;
  foot->width = 0.8f;
  foot->height = 0.8f;
  foot->depth = 2.0f;
  
  // Put leg parts together
  SoGroup *leg = new SoGroup;      
  leg->addChild(thigh);
  leg->addChild(calfTransform);
  leg->addChild(calf);
  leg->addChild(footTransform);
  leg->addChild(foot);
  
  SoTransform *leftTransform = new SoTransform;
  leftTransform->translation = SbVec3f(1.0f, -4.25f, 0.0f);
  
  // Left leg
  SoSeparator *leftLeg = new SoSeparator;   
  leftLeg->addChild(leftTransform);
  leftLeg->addChild(leg);
  
  SoTransform *rightTransform = new SoTransform;
  rightTransform->translation.setValue(-1.0f, -4.25f, 0.0f);
  
  // Right leg
  SoSeparator *rightLeg = new SoSeparator;   
  rightLeg->addChild(rightTransform);
  rightLeg->addChild(leg);
  
  // Parts for body
  SoTransform *bodyTransform = new SoTransform;    
  bodyTransform->translation.setValue(0.0f, 3.0f, 0.0f);
  
  SoMaterial *bronze = new SoMaterial;
  bronze->ambientColor.setValue(0.33f, 0.22f, 0.27f);
  bronze->diffuseColor.setValue(0.78f, 0.57f, 0.11f);
  bronze->specularColor.setValue(0.99f, 0.94f, 0.81f);
  bronze->shininess = 0.28f;
  
  SoCylinder *bodyCylinder = new SoCylinder;
  bodyCylinder->radius = 2.5f;
  bodyCylinder->height = 6.0f;
  
  // Construct body out of parts 
  SoSeparator *body = new SoSeparator;  
  body->addChild(bodyTransform);      
  body->addChild(bronze);
  body->addChild(bodyCylinder);
  body->addChild(leftLeg);
  body->addChild(rightLeg);
  
  // Head parts
  SoTransform *headTransform = new SoTransform;   
  headTransform->translation.setValue(0.0f, 7.5f, 0.0f);
  headTransform->scaleFactor.setValue(1.5f, 1.5f, 1.5f);
  
  SoMaterial *silver = new SoMaterial;
  silver->ambientColor.setValue(0.2f, 0.2f, 0.2f);
  silver->diffuseColor.setValue(0.6f, 0.6f, 0.6f);
  silver->specularColor.setValue(0.5f, 0.5f, 0.5f);
  silver->shininess = 0.5f;
  
  SoSphere *headSphere = new SoSphere;
  
  // Construct head
  SoSeparator *head = new SoSeparator;      
  head->addChild(headTransform);
  head->addChild(silver);
  head->addChild(headSphere);
  
  // Robot is just head and body
  SoSeparator *robot = new SoSeparator;  
  robot->addChild(body);               
  robot->addChild(head);
  
  // CODE FOR The Inventor Mentor ENDS HERE
  //////////////////////////////////////////////////////////////
  
  return robot;
}


int
main(int , char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // This function contains our code fragment.
  root->addChild(makeRobot());
  
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Robot");
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myViewer;

  root->unref();

  SoXt::finish();

  return 0;
}




