/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 3.
 *
 *  Create a little scene graph and then name some nodes and
 *  get back nodes by name.
 *------------------------------------------------------------*/

#include <Inventor/SoDB.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/sensors/SoNodeSensor.h>

void
RemoveCube()
{
  // Remove the cube named 'MyCube' from the separator named
  // 'Root'.  In a real application, isOfType() would probably
  // be used to make sure the nodes are of the correct type
  // before doing the cast.
  
  SoSeparator *myRoot = (SoSeparator *)SoNode::getByName("Root");
  SoCube *myCube = (SoCube *)SoNode::getByName("MyCube");
  
  myRoot->removeChild(myCube);
}


int
main(int, char **)
{
  SoDB::init();
  
  // Create some objects and give them names:
  SoSeparator *root = new SoSeparator;
  root->ref();
  root->setName("Root");
  
  SoCube *myCube = new SoCube;
  root->addChild(myCube);
  myCube->setName("MyCube");
  
  SoSphere *mySphere = new SoSphere;
  root->addChild(mySphere);
  mySphere->setName("MySphere");
  
  RemoveCube();

  root->unref();
  SoDB::finish();
  return 0;
}



