/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 4, example 1.
 *
 *  Camera example.  
 *  A blinker node is used to switch between three 
 *  different views of the same scene. The cameras are 
 *  switched once per second.
 *------------------------------------------------------------*/



#include <Inventor/SbLinear.h>

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/nodes/SoBlinker.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>


int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL)
    exit(1);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Create a blinker node and put it in the scene. A blinker
  // switches between its children at timed intervals.
  SoBlinker *myBlinker = new SoBlinker;
  root->addChild(myBlinker);
  
  // Create three cameras. Their positions will be set later.
  // This is because the viewAll method depends on the size
  // of the render area, which has not been created yet.
  SoOrthographicCamera *orthoViewAll =new SoOrthographicCamera;
  SoPerspectiveCamera *perspViewAll = new SoPerspectiveCamera;
  SoPerspectiveCamera *perspOffCenter =new SoPerspectiveCamera;
  myBlinker->addChild(orthoViewAll);
  myBlinker->addChild(perspViewAll);
  myBlinker->addChild(perspOffCenter);
  
  // Create a light
  root->addChild(new SoDirectionalLight);
  
  // Read the object from a file and add to the scene
  SoInput myInput;
  if (!myInput.openFile("$OIVHOME/examples/data/Inventor/parkbench.iv")) 
    exit(1);
  SoSeparator *fileContents = SoDB::readAll(&myInput);
  if (fileContents == NULL) exit (1);
  
  SoMaterial *myMaterial = new SoMaterial;
  myMaterial->diffuseColor.setValue(0.8f, 0.23f, 0.03f); 
  root->addChild(myMaterial);
  root->addChild(fileContents);
  
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  
  // Establish camera positions. 
  // First do a viewAll on all three cameras.  
  // Then modify the position of the off-center camera.
  SbViewportRegion myRegion(myRenderArea->getSize());
  orthoViewAll->viewAll(root, myRegion);
  perspViewAll->viewAll(root, myRegion);
  perspOffCenter->viewAll(root, myRegion);
  SbVec3f initialPos; 
  initialPos = perspOffCenter->position.getValue();
  float x, y, z;
  initialPos.getValue(x,y,z);
  perspOffCenter->position.setValue(x + x/2.0f, y + y/2.0f, z + z/4.0f);
  
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("Cameras");
  myRenderArea->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myRenderArea;
  SoXt::finish();

  return 0;
}


