/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 4, example 2.
 *
 *  Lights example.  
 *  Read in an object from a file.
 *  Use the ExaminerViewer to view it with two light sources.
 *  The red directional light doesn't move; the green point 
 *  light is moved back and forth using a shuttle node.
 *------------------------------------------------------------*/

#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPointLight.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoShuttle.h>
#include <Inventor/nodes/SoTransformSeparator.h>


int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL)
    exit(1);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Add a directional light
  SoDirectionalLight *myDirLight = new SoDirectionalLight;
  myDirLight->direction.setValue(0, -1, -1);
  myDirLight->color.setValue(1, 0, 0);
  root->addChild(myDirLight);
  
  // Put the shuttle and the light below a transform separator.
  // A transform separator pushes and pops the transformation 
  // just like a separator node, but other aspects of the state 
  // are not pushed and popped. So the shuttle's translation 
  // will affect only the light. But the light will shine on 
  // the rest of the scene.
  SoTransformSeparator *myTransformSeparator = new SoTransformSeparator;
  root->addChild(myTransformSeparator);
  
  // A shuttle node translates back and forth between the two
  // fields translation0 and translation1.  
  // This moves the light.
  SoShuttle *myShuttle = new SoShuttle;
  myTransformSeparator->addChild(myShuttle);
  myShuttle->translation0.setValue(-2, -1, 3);
  myShuttle->translation1.setValue( 1,  2, -3);
  
  // Add the point light below the transformSeparator
  SoPointLight *myPointLight = new SoPointLight;
  myTransformSeparator->addChild(myPointLight);
  myPointLight->color.setValue(0, 1, 0);
  
  root->addChild(new SoCone);
  
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Lights");
  myViewer->setHeadlight(FALSE);
  myViewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}


