/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 5, example 1.
 *
 *  This example builds an obelisk using the Face Set node.
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoFaceSet.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoNormal.h>
#include <Inventor/nodes/SoNormalBinding.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoVertexProperty.h>

//////////////////////////////////////////////////////////////
// CODE FOR The Inventor Mentor STARTS HERE

//  Eight polygons. The first four are triangles 
//  The second four are quadrilaterals for the sides.
static const float 
vertices[28][3] =
{
  { 0.0f, 30.0f, 0.0f}, {-2.0f,27.0f, 2.0f}, { 2.0f,27.0f, 2.0f}, // front tri
  { 0.0f, 30.0f, 0.0f}, {-2.0f,27.0f,-2.0f}, {-2.0f,27.0f, 2.0f}, // left  tri
  { 0.0f, 30.0f, 0.0f}, { 2.0f,27.0f,-2.0f}, {-2.0f,27.0f,-2.0f}, // rear  tri
  { 0.0f, 30.0f, 0.0f}, { 2.0f,27.0f, 2.0f}, { 2.0f,27.0f,-2.0f}, // right tri
  {-2.0f, 27.0f, 2.0f}, {-4.0f, 0.0f, 4.0f}, 
  { 4.0f,  0.0f, 4.0f}, { 2.0f,27.0f, 2.0f}, // front quad
  {-2.0f, 27.0f,-2.0f}, {-4.0f, 0.0f,-4.0f},
  {-4.0f,  0.0f, 4.0f}, {-2.0f,27.0f, 2.0f}, // left  quad
  { 2.0f, 27.0f,-2.0f}, { 4.0f, 0.0f,-4.0f},
  {-4.0f,  0.0f,-4.0f}, {-2.0f,27.0f,-2.0f}, // rear  quad
  { 2.0f, 27.0f, 2.0f}, { 4.0f, 0.0f, 4.0f},
  { 4.0f,  0.0f,-4.0f}, { 2.0f,27.0f,-2.0f}  // right quad
};

// Number of vertices in each polygon:
static int32_t numvertices[8] = {3, 3, 3, 3, 4, 4, 4, 4};

// Normals for each polygon:
static const float norms[8][3] =
{ 
  {0.0f, 0.555f, 0.832f}, {-0.832f, 0.555f, 0.0f}, // front, left tris
  {0.0f, 0.555f,-0.832f}, { 0.832f, 0.555f, 0.0f}, // rear, right tris
  
  {0.0f, 0.0739f, 0.9973f}, {-0.9972f, 0.0739f, 0.0f}, // front, left quads
  {0.0f, 0.0739f,-0.9973f}, { 0.9972f, 0.0739f, 0.0f}, // rear, right quads
};

SoSeparator *
makeObeliskFaceSet()
{
  SoSeparator *obelisk = new SoSeparator();
  obelisk->ref();
  
  // This is the preferred code for Inventor 2.1
  
  // Using the new SoVertexProperty node is more efficient
  SoVertexProperty *myVertexProperty = new SoVertexProperty;
  
  // Define the normals used:
  myVertexProperty->normal.setValues(0, 8, norms);
  myVertexProperty->normalBinding = SoNormalBinding::PER_FACE;
  
  // Define material for obelisk
  myVertexProperty->orderedRGBA.setValue(SbColor(0.4f, 0.4f, 0.4f).getPackedValue());
  
  // Define coordinates for vertices
  myVertexProperty->vertex.setValues(0, 28, vertices);
  
  // Define the FaceSet
  SoFaceSet *myFaceSet = new SoFaceSet;
  myFaceSet->numVertices.setValues(0, 8, numvertices);
  
  myFaceSet->vertexProperty.setValue(myVertexProperty);
  obelisk->addChild(myFaceSet);
  
 
  obelisk->unrefNoDelete();
  return obelisk;
}

// CODE FOR The Inventor Mentor ENDS HERE
//////////////////////////////////////////////////////////////

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  root->addChild(makeObeliskFaceSet());
  
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Face Set: Obelisk");
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  root->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}



