/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 5, example 2.
 *
 *  This example creates an IndexedFaceSet. It creates 
 *  the first stellation of the dodecahedron.
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoIndexedFaceSet.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoMaterialBinding.h>
#include <Inventor/nodes/SoSeparator.h>


//////////////////////////////////////////////////////////////
// CODE FOR The Inventor Mentor STARTS HERE

//
// Positions of all of the vertices:
//
static const float 
vertexPositions[12][3] =
{
  { 0.0000f,  1.2142f,  0.7453f},  // top
    
  { 0.0000f,  1.2142f, -0.7453f},  // points surrounding top
  {-1.2142f,  0.7453f,  0.0000f},
  {-0.7453f,  0.0000f,  1.2142f}, 
  { 0.7453f,  0.0000f,  1.2142f}, 
  { 1.2142f,  0.7453f,  0.0000f},
  
  { 0.0000f, -1.2142f,  0.7453f},  // points surrounding bottom
  {-1.2142f, -0.7453f,  0.0000f}, 
  {-0.7453f,  0.0000f, -1.2142f},
  { 0.7453f,  0.0000f, -1.2142f}, 
  { 1.2142f, -0.7453f,  0.0000f}, 
  
  { 0.0000f, -1.2142f, -0.7453f}, // bottom
};

//
// Connectivity, information; 12 faces with 5 vertices each },
// (plus the end-of-face indicator for each face):
//

static int32_t 
indices[72] =
{
  1, 2,  3,  4, 5, SO_END_FACE_INDEX, // top face
  
  0, 1, 8, 7, 3, SO_END_FACE_INDEX, // 5 faces about top
  0, 2, 7, 6, 4, SO_END_FACE_INDEX,
  0, 3, 6,10, 5, SO_END_FACE_INDEX,
  0, 4,10, 9, 1, SO_END_FACE_INDEX,
  0, 5, 9, 8, 2, SO_END_FACE_INDEX, 
  
  9, 5, 4, 6,11, SO_END_FACE_INDEX, // 5 faces about bottom
  10, 4, 3, 7,11, SO_END_FACE_INDEX,
  6, 3, 2, 8,11, SO_END_FACE_INDEX,
  7, 2, 1, 9,11, SO_END_FACE_INDEX,
  8, 1, 5,10,11, SO_END_FACE_INDEX,
  
  6, 7, 8, 9,10, SO_END_FACE_INDEX, // bottom face
};
 
// Colors for the 12 faces
static const float 
colors[12][3] =
{
  { 1.0f, 0.0f, 0.0f}, { 0.0f, 0.0f, 1.0f}, 
  { 0.0f, 0.7f, 0.7f}, { 0.0f, 1.0f, 0.0f},
  { 0.7f, 0.7f, 0.0f}, { 0.7f, 0.0f, 0.7f}, 
  { 0.0f, 0.0f, 1.0f}, { 0.7f, 0.0f, 0.7f},
  { 0.7f, 0.7f, 0.0f}, { 0.0f, 1.0f, 0.0f}, 
  { 0.0f, 0.7f, 0.7f}, { 1.0f, 0.0f, 0.0f}
};

// Routine to create a scene graph representing a dodecahedron
SoSeparator *
makeStellatedDodecahedron()
{
  SoSeparator *result = new SoSeparator;
  result->ref();
  
  // This is the preferred code for Inventor 2.1
  
  // Using the new SoVertexProperty node is more efficient
  SoVertexProperty *myVertexProperty = new SoVertexProperty;
  
  // Define colors for the faces
  for (int i=0; i<12; i++)
    myVertexProperty->orderedRGBA.set1Value(i, SbColor(colors[i]).getPackedValue());
  myVertexProperty->materialBinding = SoMaterialBinding::PER_FACE;
  
  // Define coordinates for vertices
  myVertexProperty->vertex.setValues(0, 12, vertexPositions);
  
  // Define the IndexedFaceSet, with indices into
  // the vertices:
  SoIndexedFaceSet *myFaceSet = new SoIndexedFaceSet;
  myFaceSet->coordIndex.setValues(0, 72, indices);
  
  myFaceSet->vertexProperty.setValue(myVertexProperty);
  result->addChild(myFaceSet);
  
  
  result->unrefNoDelete();
  return result;
}

// CODE FOR The Inventor Mentor ENDS HERE
//////////////////////////////////////////////////////////////

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL)
    exit(1);
  
  SoSeparator *root = makeStellatedDodecahedron();
  root->ref();
  
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Indexed Face Set: Stellated Dodecahedron");
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myViewer;
  root->unref();
  SoXt::finish();

  return 0;
}



