/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 5, example 3.
 *
 *  This example creates a TriangleStripSet. It creates
 *  a pennant-shaped flag.
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoMaterialBinding.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoShapeHints.h>
#include <Inventor/nodes/SoTriangleStripSet.h>


//////////////////////////////////////////////////////////////
// CODE FOR The Inventor Mentor STARTS HERE

//
// Positions of all of the vertices:
//
static const float 
vertexPositions[40][3] =
{
  { 0.0f,12.0f, 0.0f }, { 0.0f,15.0f, 0.0f},
  { 2.1f,12.1f,-0.2f }, { 2.1f,14.6f,-0.2f},
  { 4.0f,12.5f,-0.7f }, { 4.0f,14.5f,-0.7f},
  { 4.5f,12.6f,-0.8f }, { 4.5f,14.4f,-0.8f},
  { 5.0f,12.7f,-1.0f }, { 5.0f,14.4f,-1.0f},
  { 4.5f,12.8f,-1.4f }, { 4.5f,14.6f,-1.4f},
  { 4.0f,12.9f,-1.6f }, { 4.0f,14.8f,-1.6f},
  { 3.3f,12.9f,-1.8f }, { 3.3f,14.9f,-1.8f},
  { 3.0f,13.0f,-2.0f }, { 3.0f,14.9f,-2.0f}, 
  { 3.3f,13.1f,-2.2f }, { 3.3f,15.0f,-2.2f},
  { 4.0f,13.2f,-2.5f }, { 4.0f,15.0f,-2.5f},
  { 6.0f,13.5f,-2.2f }, { 6.0f,14.8f,-2.2f},
  { 8.0f,13.4f,-2.0f }, { 8.0f,14.6f,-2.0f},
  {10.0f,13.7f,-1.8f }, {10.0f,14.4f,-1.8f},
  {12.0f,14.0f,-1.3f }, {12.0f,14.5f,-1.3f},
  {15.0f,14.9f,-1.2f }, {15.0f,15.0f,-1.2f},
  
  {-0.5f,15.0f, 0.0f }, {-0.5f, 0.0f, 0.0f},   // the flagpole
  { 0.0f,15.0f, 0.5f }, { 0.0f, 0.0f, 0.5f},
  { 0.0f,15.0f,-0.5f }, { 0.0f, 0.0f,-0.5f},
  {-0.5f,15.0f, 0.0f }, {-0.5f, 0.0f, 0.0f}
};

// Number of vertices in each strip.
static int32_t 
numVertices[2] =
{
  32, // flag
  8   // pole
};
 
// Colors for the 12 faces
static const float 
colors[2][3] =
{
  { 0.5f, 0.5f, 1.0f }, // purple flag
  { 0.4f, 0.4f, 0.4f }, // grey flagpole
};

// Routine to create a scene graph representing a pennant.
SoSeparator *
makePennant()
{
  SoSeparator *result = new SoSeparator;
  result->ref();
  
  // A shape hints tells the ordering of polygons. 
  // This insures double sided lighting.
  SoShapeHints *myHints = new SoShapeHints;
  myHints->vertexOrdering = SoShapeHints::COUNTERCLOCKWISE;
  result->addChild(myHints);
  
  // This is the preferred code for Inventor 2.1
  
  // Using the new SoVertexProperty node is more efficient
  SoVertexProperty *myVertexProperty = new SoVertexProperty;
  
  // Define colors for the strips
  for (int i=0; i<2; i++)
    myVertexProperty->orderedRGBA.set1Value(i, SbColor(colors[i]).getPackedValue());
  myVertexProperty->materialBinding = SoMaterialBinding::PER_PART;
  
  // Define coordinates for vertices
  myVertexProperty->vertex.setValues(0, 40, vertexPositions);
  
  // Define the TriangleStripSet, made of two strips.
  SoTriangleStripSet *myStrips = new SoTriangleStripSet;
  myStrips->numVertices.setValues(0, 2, numVertices);
  
  myStrips->vertexProperty.setValue(myVertexProperty);
  result->addChild(myStrips);

  
  result->unrefNoDelete();
  return result;
}

// CODE FOR The Inventor Mentor ENDS HERE
//////////////////////////////////////////////////////////////

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  SoSeparator *root = makePennant();
  root->ref();
  
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Triangle Strip Set: Pennant");
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}



