/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 5, example 4.
 *
 *  This example creates the St. Louis Arch using a QuadMesh.
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoQuadMesh.h>
#include <Inventor/nodes/SoSeparator.h>


//////////////////////////////////////////////////////////////
// CODE FOR The Inventor Mentor STARTS HERE

// Positions of all of the vertices:
static const float 
vertexPositions[160][3] =
{  // 1st row
  {-13.0f,  0.0f, 1.5f}, {-10.3f, 13.7f, 1.2f}, { -7.6f, 21.7f, 1.0f}, 
  { -5.0f, 26.1f, 0.8f}, { -2.3f, 28.2f, 0.6f}, { -0.3f, 28.8f, 0.5f},
  {  0.3f, 28.8f, 0.5f}, {  2.3f, 28.2f, 0.6f}, {  5.0f, 26.1f, 0.8f}, 
  {  7.6f, 21.7f, 1.0f}, { 10.3f, 13.7f, 1.2f}, { 13.0f,  0.0f, 1.5f},
  // 2nd row
  {-10.0f,  0.0f, 1.5f}, { -7.9f, 13.2f, 1.2f}, { -5.8f, 20.8f, 1.0f}, 
  { -3.8f, 25.0f, 0.8f}, { -1.7f, 27.1f, 0.6f}, { -0.2f, 27.6f, 0.5f},
  {  0.2f, 27.6f, 0.5f}, {  1.7f, 27.1f, 0.6f}, {  3.8f, 25.0f, 0.8f}, 
  {  5.8f, 20.8f, 1.0f}, {  7.9f, 13.2f, 1.2f}, { 10.0f,  0.0f, 1.5f},
  // 3rd row
  {-10.0f,  0.0f,-1.5f}, { -7.9f, 13.2f,-1.2f}, { -5.8f, 20.8f,-1.0f}, 
  { -3.8f, 25.0f,-0.8f}, { -1.7f, 27.1f,-0.6f}, { -0.2f, 27.6f,-0.5f},
  {  0.2f, 27.6f,-0.5f}, {  1.7f, 27.1f,-0.6f}, {  3.8f, 25.0f,-0.8f}, 
  {  5.8f, 20.8f,-1.0f}, {  7.9f, 13.2f,-1.2f}, { 10.0f,  0.0f,-1.5f},
  // 4th row 
  {-13.0f,  0.0f,-1.5f}, {-10.3f, 13.7f,-1.2f}, { -7.6f, 21.7f,-1.0f}, 
  { -5.0f, 26.1f,-0.8f}, { -2.3f, 28.2f,-0.6f}, { -0.3f, 28.8f,-0.5f},
  {  0.3f, 28.8f,-0.5f}, {  2.3f, 28.2f,-0.6f}, {  5.0f, 26.1f,-0.8f}, 
  {  7.6f, 21.7f,-1.0f}, { 10.3f, 13.7f,-1.2f}, { 13.0f,  0.0f,-1.5f},
  // 5th row
  {-13.0f,  0.0f, 1.5f}, {-10.3f, 13.7f, 1.2f}, { -7.6f, 21.7f, 1.0f}, 
  { -5.0f, 26.1f, 0.8f}, { -2.3f, 28.2f, 0.6f}, { -0.3f, 28.8f, 0.5f},
  {  0.3f, 28.8f, 0.5f}, {  2.3f, 28.2f, 0.6f}, {  5.0f, 26.1f, 0.8f}, 
  {  7.6f, 21.7f, 1.0f}, { 10.3f, 13.7f, 1.2f}, { 13.0f,  0.0f, 1.5}
};

//Routine to create a scene graph representing an arch.
SoSeparator *
makeArch()
{
  SoSeparator *result = new SoSeparator;
  result->ref();
  
  // This is the preferred code for Inventor 2.1
  
  // Using the new SoVertexProperty node is more efficient
  SoVertexProperty *myVertexProperty = new SoVertexProperty;
  
  // Define the material
  myVertexProperty->orderedRGBA.setValue(SbColor(0.78f, 0.57f, 0.11f).getPackedValue());
  
  // Define coordinates for vertices
  myVertexProperty->vertex.setValues(0, 60, vertexPositions);
  // Define the QuadMesh.
  SoQuadMesh *myQuadMesh = new SoQuadMesh;
  myQuadMesh->verticesPerRow = 12;
  myQuadMesh->verticesPerColumn = 5;
  myQuadMesh->vertexProperty.setValue(myVertexProperty);
  result->addChild(myQuadMesh);

  
  result->unrefNoDelete();
  return result;
}

// CODE FOR The Inventor Mentor ENDS HERE
//////////////////////////////////////////////////////////////

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  SoSeparator *root = makeArch();
  root->ref();
  
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Quad Mesh: Arch");
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}


