/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 5, example 6.
 *
 *  This example shows the effect of different order of
 *  operation of transforms.  The left object is first
 *  scaled, then rotated, and finally translated to the left.  
 *  The right object is first rotated, then scaled, and finally
 *  translated to the right.
 *------------------------------------------------------------*/



#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/SoDB.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoRotationXYZ.h>
#include <Inventor/nodes/SoScale.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTranslation.h>


int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Create two separators, for left and right objects.
  SoSeparator *leftSep = new SoSeparator;
  SoSeparator *rightSep = new SoSeparator;
  root->addChild(leftSep);
  root->addChild(rightSep);
  
  // Create the transformation nodes
  SoTranslation *leftTranslation  = new SoTranslation;
  SoTranslation *rightTranslation = new SoTranslation;
  SoRotationXYZ *myRotation = new SoRotationXYZ;
  SoScale *myScale = new SoScale;
  
  // Fill in the values
  leftTranslation->translation.setValue(-1.0f, 0.0f, 0.0f);
  rightTranslation->translation.setValue(1.0f, 0.0f, 0.0f);
  myRotation->angle = (float)(M_PI/2.0f);   // 90 degrees
  myRotation->axis = SoRotationXYZ::X;
  myScale->scaleFactor.setValue(2.0f, 1.0f, 3.0f);
  
  // Add transforms to the scene.
  leftSep->addChild(leftTranslation);   // left graph
  leftSep->addChild(myRotation);        // then rotated
  leftSep->addChild(myScale);           // first scaled
  
  rightSep->addChild(rightTranslation); // right graph
  rightSep->addChild(myScale);          // then scaled
  rightSep->addChild(myRotation);       // first rotated
  
  // Read an object from file. (as in example 4.2.Lights)
  SoInput myInput;
  if (!myInput.openFile("$OIVHOME/examples/data/Inventor/temple.iv")) 
    exit (1);
  SoSeparator *fileContents = SoDB::readAll(&myInput);
  if (fileContents == NULL) exit (1);
  
  // Add an instance of the object under each separator.
  leftSep->addChild(fileContents);
  rightSep->addChild(fileContents);
  
  // Construct a renderArea and display the scene.
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Transform Ordering");
  myViewer->viewAll();
  myViewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}


