/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 6, example 1.
 *
 *  This example renders a globe and uses 2D text to label the
 *  continents Africa and Asia.
 *------------------------------------------------------------*/



#include <Inventor/nodes/SoComplexity.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoGroup.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoTranslation.h>

#include <Inventor/nodes/SoTexture2Transform.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#ifdef _WIN32
#  define LOCALFONTNAME "Times New Roman;Regular"
#else
#  define LOCALFONTNAME "Times-Roman"
#endif

int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if(myWindow == NULL) exit(1);
  
  SoGroup *root = new SoGroup;
  root->ref();
  
  // Choose a font
  SoFont *myFont = new SoFont;
  myFont->name.setValue(LOCALFONTNAME);
  
  myFont->size.setValue(24.0f);
  root->addChild(myFont);
  
  // Add the globe, a sphere with a texture map.
  // Put it within a separator.
  SoSeparator *sphereSep = new SoSeparator;
  SoTexture2  *myTexture2 = new SoTexture2;
  SoComplexity *sphereComplexity = new SoComplexity;
  sphereComplexity->value = 0.55f;
  root->addChild(sphereSep);
  sphereSep->addChild(myTexture2);
  sphereSep->addChild(sphereComplexity);
  sphereSep->addChild(new SoSphere);
  myTexture2->filename = "$OIVHOME/examples/data/Inventor/globe.rgb";
  
  // Add Text2 for AFRICA, translated to proper location.
  SoSeparator *africaSep = new SoSeparator;
  SoTranslation *africaTranslate = new SoTranslation;
  SoText2 *africaText = new SoText2;
  africaTranslate->translation.setValue(.25,.0,1.25);
  africaText->string = "AFRICA";
  root->addChild(africaSep);
  africaSep->addChild(africaTranslate);
  africaSep->addChild(africaText);
  
  // Add Text2 for ASIA, translated to proper location.
  SoSeparator *asiaSep = new SoSeparator;
  SoTranslation *asiaTranslate = new SoTranslation;
  SoText2 *asiaText = new SoText2;
  asiaTranslate->translation.setValue(0.8f, 0.8f, 0.0f);
  asiaText->string = "ASIA";
  root->addChild(asiaSep);
  asiaSep->addChild(asiaTranslate);
  asiaSep->addChild(asiaText);
  
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("2D Text");
  
  // In Inventor 2.1, if the machine does not have hardware texture
  // mapping, we must override the default drawStyle to display textures.
  myViewer->setDrawStyle(SoXtViewer::STILL, SoXtViewer::VIEW_AS_IS);
  
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}


