/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 6, example 2.
 *
 *  This example renders a globe and uses 3D text to label the
 *  continents Africa and Asia.
 *------------------------------------------------------------*/



#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoComplexity.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoGroup.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoMaterialBinding.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoText3.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoTexture2Transform.h>

#ifdef _WIN32
#  define LOCALFONTNAME "Times New Roman;Regular"
#else
#  define LOCALFONTNAME "Utopia-Regular"
#endif

int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if(myWindow == NULL)
    exit(1);
  
  SoGroup *root = new SoGroup;
  root->ref();
  
  // Choose a font
  SoFont *myFont = new SoFont;
  
  myFont->name.setValue(LOCALFONTNAME);
  myFont->size.setValue(0.2f);
  root->addChild(myFont);
  
  // We'll color the front of the text white, and the sides 
  // dark grey. So use a materialBinding of PER_PART and
  // two diffuseColor values in the material node.
  SoMaterial *myMaterial = new SoMaterial;
  SoMaterialBinding *myBinding = new SoMaterialBinding;
  myMaterial->diffuseColor.set1Value(0,SbColor(1.0F, 1.0F, 1.0F));
  myMaterial->diffuseColor.set1Value(1,SbColor(0.1F, 0.1F, 0.1F));
  myMaterial->diffuseColor.set1Value(2,SbColor(1.0F, 1.0F, 1.0F));
  myBinding->value.setValue(SoMaterialBinding::PER_PART);

  
  // Create the globe
  SoSeparator *sphereSep = new SoSeparator;
  SoTexture2  *myTexture2 = new SoTexture2;
  SoComplexity *sphereComplexity = new SoComplexity;
  sphereComplexity->value = 0.55F;
  root->addChild(sphereSep);
  sphereSep->addChild(myTexture2);
  sphereSep->addChild(sphereComplexity);
  sphereSep->addChild(new SoSphere);
  myTexture2->filename = "$OIVHOME/examples/data/Inventor/globe.rgb";
  
  SoSeparator *text = new SoSeparator;
  root->addChild(text);
  text->addChild(myMaterial);
  text->addChild(myBinding);

  // Add Text3 for AFRICA, transformed to proper location.
  SoSeparator *africaSep = new SoSeparator;
  SoTransform *africaTransform = new SoTransform;
  SoText3 *africaText = new SoText3;
  africaTransform->rotation.setValue(SbVec3f(0,1,0), 0.4F);
  africaTransform->translation.setValue(0.25F, 0.0F, 1.25F);
  africaText->parts = SoText3::ALL;
  africaText->string = "AFRICA";
  text->addChild(africaSep);
  africaSep->addChild(africaTransform);
  africaSep->addChild(africaText);
  
  // Add Text3 for ASIA, transformed to proper location.
  SoSeparator *asiaSep = new SoSeparator;
  SoTransform *asiaTransform = new SoTransform;
  SoText3 *asiaText = new SoText3;
  asiaTransform->rotation.setValue(SbVec3f(0.0F, 1.0F, 0.0F), 1.5F);
  asiaTransform->translation.setValue(0.8F, 0.6F, 0.5F);
  asiaText->parts = SoText3::ALL;
  asiaText->string = "ASIA";
  text->addChild(asiaSep);
  asiaSep->addChild(asiaTransform);
  asiaSep->addChild(asiaText);

  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("3D Text");
  
  // In Inventor 2.1, if the machine does not have hardware texture
  // mapping, we must override the default drawStyle to display textures.
  myViewer->setDrawStyle(SoXtViewer::STILL, SoXtViewer::VIEW_AS_IS);
  
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();
  
  return 0;
}


