/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 6, example 3.
 *
 *  This example renders arguments as text within an
 *  SoXTExaminerViewer.  It is a little fancier than 6.2.
 *------------------------------------------------------------*/



#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoGroup.h>
#include <Inventor/nodes/SoLinearProfile.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoMaterialBinding.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoProfileCoordinate2.h>
#include <Inventor/nodes/SoText3.h>

#ifdef _WIN32
#  define LOCALFONTNAME "Times New Roman;Regular"
#else
#  define LOCALFONTNAME "Times-Roman"
#endif

int
main(int argc, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if(myWindow == NULL) exit(1);
  
  SoGroup *root = new SoGroup;
  root->ref();
  
  // Set up camera 
  SoPerspectiveCamera	*myCamera = new SoPerspectiveCamera;
  myCamera->position.setValue(0, -(argc - 1.f) / 2.f, 10.f);
  myCamera->nearDistance.setValue(5.0f);
  myCamera->farDistance.setValue(15.0f);
  root->addChild(myCamera);
  
  // Let's make the front of the text white, 
  // and the sides and back shiny yellow
  SoMaterial *myMaterial = new SoMaterial;
  SbColor colors[3];
  // diffuse
  colors[0].setValue(1, 1, 1);
  colors[1].setValue(1, 1, 0);
  colors[2].setValue(1, 1, 0);
  myMaterial->diffuseColor.setValues(0, 3, colors);
  
  // specular
  colors[0].setValue(1, 1, 1);
  // Note: Inventor 2.1 doesn't support multiple specular colors.
  /* 
  colors[1].setValue(1, 1, 0);
  colors[2].setValue(1, 1, 0);
  myMaterial->specularColor.setValues(0, 3, colors);
  */
  myMaterial->specularColor.setValue(colors[0]);
  myMaterial->shininess.setValue(0.1f);
  root->addChild(myMaterial);
  
  // Choose a font likely to exist.
  SoFont *myFont = new SoFont;
  myFont->name.setValue(LOCALFONTNAME);
  
  root->addChild(myFont);
  
  // Specify a beveled cross-section for the text
  SoProfileCoordinate2 *myProfileCoords = 
    new SoProfileCoordinate2;
  SbVec2f coords[4];
  coords[0].setValue(0.00f, 0.00f);
  coords[1].setValue(0.25f, 0.25f);
  coords[2].setValue(1.25f, 0.25f);
  coords[3].setValue(1.50f, 0.00f);
  myProfileCoords->point.setValues(0, 4, coords);
  root->addChild(myProfileCoords);
  
  SoLinearProfile *myLinearProfile = new SoLinearProfile;
  int32_t	index[4] ;
  index[0] = 0;
  index[1] = 1;
  index[2] = 2;
  index[3] = 3;
  myLinearProfile->index.setValues(0, 4, index);
  root->addChild(myLinearProfile);
  
  // Set the material binding to PER_PART
  SoMaterialBinding *myMaterialBinding = new SoMaterialBinding;
  myMaterialBinding->
    value.setValue(SoMaterialBinding::PER_PART);
  root->addChild(myMaterialBinding);
  
  // Add the text
  SoText3 *myText3 = new SoText3;
  myText3->string.setValue("Beveled Text");
  myText3->justification.setValue(SoText3::CENTER);
  myText3->parts.setValue(SoText3::ALL);
  
  root->addChild(myText3);
  
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Complex 3D Text");
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}


