/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 7, example 2.
 *
 *  This example illustrates using texture coordindates on
 *  a Face Set.
 *------------------------------------------------------------*/



#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoFaceSet.h>
#include <Inventor/nodes/SoNormal.h>
#include <Inventor/nodes/SoNormalBinding.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoTextureCoordinate2.h>
#include <Inventor/nodes/SoTextureCoordinateBinding.h>

int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if(myWindow == NULL) exit(1);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Choose a texture 
  SoTexture2 *brick = new SoTexture2;
  root->addChild(brick);
  brick->filename.setValue("$OIVHOME/examples/data/Inventor/brick.1.rgb");
  
  
  // This is the preferred code for Inventor 2.1
  
  // Using the new SoVertexProperty node is more efficient
  SoVertexProperty *myVertexProperty = new SoVertexProperty;
  
  // Define the square's spatial coordinates
  myVertexProperty->vertex.set1Value(0, SbVec3f(-3, -3, 0));
  myVertexProperty->vertex.set1Value(1, SbVec3f( 3, -3, 0));
  myVertexProperty->vertex.set1Value(2, SbVec3f( 3,  3, 0));
  myVertexProperty->vertex.set1Value(3, SbVec3f(-3,  3, 0));
  
  // Define the square's normal
  myVertexProperty->normal.set1Value(0, SbVec3f(0, 0, 1));
  
  // Define the square's texture coordinates
  myVertexProperty->texCoord.set1Value(0, SbVec2f(0, 0));
  myVertexProperty->texCoord.set1Value(1, SbVec2f(1, 0));
  myVertexProperty->texCoord.set1Value(2, SbVec2f(1, 1));
  myVertexProperty->texCoord.set1Value(3, SbVec2f(0, 1));
  
  // SoTextureCoordinateBinding node is now obsolete--in Inventor 2.1,
  // texture coordinates will always be generated if none are 
  // provided.
  /*
  SoTextureCoordinateBinding *tBind =
  new SoTextureCoordinateBinding;
  root->addChild(tBind);
  tBind->value = SoTextureCoordinateBinding::PER_VERTEX;
  */
  // Define normal binding
  myVertexProperty->normalBinding = SoNormalBinding::OVERALL;
  
  // Define a FaceSet
  SoFaceSet *myFaceSet = new SoFaceSet;
  root->addChild(myFaceSet);
  myFaceSet->numVertices.set1Value(0, 4);
  
  myFaceSet->vertexProperty.setValue(myVertexProperty);
  
  
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Texture Coordinates");
  
  // In Inventor 2.1, if the machine does not have hardware texture
  // mapping, we must override the default drawStyle to display textures.
  myViewer->setDrawStyle(SoXtViewer::STILL, SoXtViewer::VIEW_AS_IS);
  
  myViewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}


