/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 7, example 3.
 *
 *  This example illustrates using texture functions to
 *  generate texture coordinates on a sphere.
 *  It draws three texture mapped spheres, each with a 
 *  different repeat frequency as defined by the fields of the 
 *  SoTextureCoordinatePlane node.
 *------------------------------------------------------------*/



#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoTexture2Transform.h>
#include <Inventor/nodes/SoTextureCoordinatePlane.h>
#include <Inventor/nodes/SoTranslation.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>


int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if(myWindow == NULL) exit(1);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Choose a texture.
  SoTexture2 *faceTexture = new SoTexture2;
  root->addChild(faceTexture);
  faceTexture->filename.setValue("$OIVHOME/examples/data/Inventor/sillyFace.rgb");
  
  // Make the diffuse color pure white
  SoMaterial *myMaterial = new SoMaterial;
  myMaterial->diffuseColor.setValue(1,1,1);
  root->addChild(myMaterial);
  
  // This texture2Transform centers the texture about (0,0,0) 
  SoTexture2Transform *myTexXf = new SoTexture2Transform;
  myTexXf->translation.setValue(.5,.5);
  root->addChild(myTexXf);
  
  // Define a texture coordinate plane node.  This one will 
  // repeat with a frequency of two times per unit length.
  // Add a sphere for it to affect.
  SoTextureCoordinatePlane *texPlane1 = new SoTextureCoordinatePlane;
  texPlane1->directionS.setValue(SbVec3f(2,0,0));
  texPlane1->directionT.setValue(SbVec3f(0,2,0));
  root->addChild(texPlane1);
  root->addChild(new SoSphere);
  
  // A translation node for spacing the three spheres.
  SoTranslation            *myTranslation = new SoTranslation;
  myTranslation->translation.setValue(2.5,0,0);
  
  // Create a second sphere with a repeat frequency of 1.
  SoTextureCoordinatePlane *texPlane2 = new SoTextureCoordinatePlane;
  texPlane2->directionS.setValue(SbVec3f(1,0,0));
  texPlane2->directionT.setValue(SbVec3f(0,1,0));
  root->addChild(myTranslation);
  root->addChild(texPlane2);
  root->addChild(new SoSphere);
  
  // The third sphere has a repeat frequency of .5
  SoTextureCoordinatePlane *texPlane3 = new SoTextureCoordinatePlane;
  texPlane3->directionS.setValue(SbVec3f(.5,0,0));
  texPlane3->directionT.setValue(SbVec3f(0,.5,0));
  root->addChild(myTranslation);
  root->addChild(texPlane3);
  root->addChild(new SoSphere);
  
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Texture Coordinate Plane");
  
  // In Inventor 2.1, if the machine does not have hardware texture
  // mapping, we must override the default drawStyle to display textures.
  myViewer->setDrawStyle(SoXtViewer::STILL, SoXtViewer::VIEW_AS_IS);
  
  myViewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;
  SoXt::finish();

  return 0;
}


