/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 9, example 3.
 *
 *  Search Action example.
 *  Read in a scene from a file.
 *  Search through the scene looking for a light.
 *  If none exists, add a directional light to the scene
 *  and print out the modified scene.
 *-----------------------------------------------------------*/
 
#include <Inventor/SoDB.h>
#include <Inventor/actions/SoSearchAction.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoSeparator.h>


int
main(int, char **)
{
  
  // Initialize Inventor
  SoDB::init();
  
  // Open and read input scene graph
  SoInput sceneInput;
  if (! sceneInput.openFile("$OIVHOME/data/models/bird.iv"))
    return 1;
  
  SoSeparator *root = SoDB::readAll(&sceneInput);
  if (root == NULL) 
    return 1;
  root->ref();
  
  //////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE
  
  SoSearchAction mySearchAction;
  
  // Look for first existing light derived from class SoLight
  mySearchAction.setType(SoLight::getClassTypeId());
  mySearchAction.setInterest(SoSearchAction::FIRST);
  
  mySearchAction.apply(root);
  if (mySearchAction.getPath() == NULL) { // No lights found
    // Add a default directional light to the scene
    SoDirectionalLight *myLight = new SoDirectionalLight;
    root->insertChild(myLight, 0);
  }
  
  // CODE FOR The Inventor Mentor ENDS HERE
  //////////////////////////////////////////////////////////////
  
  SoWriteAction myWriteAction;
  
  myWriteAction.apply(root);
  
  
  root->unref();
  SoDB::finish();
  
  return 0;
}



