/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*-----------------------------------------------------------
 *  This is an example from The Inventor Mentor,
 *  chapter 9, example 5.
 *
 *  Using a callback for generated primitives.
 *  A simple scene with a sphere is created.
 *  A callback is used to write out the triangles that
 *  form the sphere in the scene.
 *----------------------------------------------------------*/

#include <Inventor/SoDB.h>
#include <Inventor/SoPrimitiveVertex.h>
#include <Inventor/actions/SoCallbackAction.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>

// Function prototypes
void printSpheres(SoNode *);
int printHeaderCallback(void *, SoCallbackAction *, const SoNode *);
void printTriangleCallback(void *, SoCallbackAction *,
                           const SoPrimitiveVertex *, 
                           const SoPrimitiveVertex *,
                           const SoPrimitiveVertex *);
void printVertex(const SoPrimitiveVertex *);

//////////////////////////////////////////////////////////////
// CODE FOR The Inventor Mentor STARTS HERE

void
printSpheres(SoNode *root)
{
  SoCallbackAction myAction;

#ifdef _WIN32
  myAction.addPreCallback(SoSphere::getClassTypeId(), 
                          printHeaderCallback, NULL);
#else
  myAction.addPreCallback(SoSphere::getClassTypeId(), 
                          (SoCallbackAction::SoCallbackActionCB *)printHeaderCallback, 
                          NULL);
#endif
  myAction.addTriangleCallback(SoSphere::getClassTypeId(), 
                               printTriangleCallback, NULL);
  myAction.apply(root);
}

int
printHeaderCallback(void *, SoCallbackAction *, 
                    const SoNode *node)
{
  printf("\n Sphere ");
  // Print the node name (if it exists) and address
  if (! !node->getName()) {
    printf("named \"%s\" ", node->getName().getString());
    printf("at address %p", node);
  }
  printf("\n");

  return SoCallbackAction::CONTINUE;
}

void
printTriangleCallback(void *, SoCallbackAction *,
                      const SoPrimitiveVertex *vertex1,
                      const SoPrimitiveVertex *vertex2,
                      const SoPrimitiveVertex *vertex3)
{
  printf("Triangle:\n");
  printVertex(vertex1);
  printVertex(vertex2);
  printVertex(vertex3);
}

void
printVertex(const SoPrimitiveVertex *vertex)
{
  const SbVec3f &point = vertex->getPoint();
  printf("\tCoords     = (%g, %g, %g)\n", 
         point[0], point[1], point[2]);

  const SbVec3f &normal = vertex->getNormal();
  printf("\tNormal     = (%g, %g, %g)\n", 
         normal[0], normal[1], normal[2]);
}

// CODE FOR The Inventor Mentor ENDS HERE
///////////////////////////////////////////////////////////////

int
main(int, char **)
{
  // Initialize Inventor
  SoDB::init();

  // Make a scene containing a red sphere
  SoSeparator *root = new SoSeparator;
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  SoMaterial *myMaterial = new SoMaterial;
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  myMaterial->diffuseColor.setValue(1.0, 0.0, 0.0);   // Red
  root->addChild(myMaterial);
  root->addChild(new SoSphere);
  root->ref();

  // Write out the triangles that form the sphere in the scene
  printSpheres(root);

  root->unref();
  SoDB::finish();

  return 0;
}


