/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*-------------------------------------------------------------
 *  This is an example from The Inventor Mentor,
 *  chapter 10, example 5.
 *
 *  The scene graph has a sphere and a text 3D object. 
 *  A selection node is placed at the top of the scene graph. 
 *  When an object is selected, a selection callback is called
 *  to change the material color of that object.
 *------------------------------------------------------------*/

#if !defined(_WIN32) && !defined(__APPLE__)
#  include <X11/Intrinsic.h>
#endif

#include <Inventor/Sb.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/nodes/SoSelection.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoText3.h>
#include <Inventor/nodes/SoTransform.h>


// global data
SoMaterial *textMaterial, *sphereMaterial;
static float reddish[] = {1.0f, 0.2f, 0.2f};  // Color when selected
static float white[] = {0.8f, 0.8f, 0.8f};    // Color when not selected

// This routine is called when an object gets selected. 
// We determine which object was selected, and change 
// that objects material color.
void
mySelectionCB(void *, SoPath *selectionPath)
{
  if (selectionPath->getTail()->
    isOfType(SoText3::getClassTypeId())) { 
    textMaterial->diffuseColor.setValue(reddish);
  } else if (selectionPath->getTail()->
    isOfType(SoSphere::getClassTypeId())) {
    sphereMaterial->diffuseColor.setValue(reddish);
  }
}

// This routine is called whenever an object gets deselected. 
// We determine which object was deselected, and reset 
// that objects material color.
void
myDeselectionCB(void *, SoPath *deselectionPath)
{
  if (deselectionPath->getTail()->
    isOfType(SoText3::getClassTypeId())) {
    textMaterial->diffuseColor.setValue(white);
  } else if (deselectionPath->getTail()->
    isOfType(SoSphere::getClassTypeId())) {
    sphereMaterial->diffuseColor.setValue(white);
  }
}

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  // Create and set up the selection node
  SoSelection *selectionRoot = new SoSelection;
  selectionRoot->ref();
  selectionRoot->policy = SoSelection::SINGLE;
  selectionRoot-> addSelectionCallback(mySelectionCB);
  selectionRoot-> addDeselectionCallback(myDeselectionCB);
  
  // Create the scene graph
  SoSeparator *root = new SoSeparator;
  selectionRoot->addChild(root);
  
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  
  // Add a sphere node
  SoSeparator *sphereRoot = new SoSeparator;
  SoTransform *sphereTransform = new SoTransform;
  sphereTransform->translation.setValue(17.0f, 17.0f, 0.0f);
  sphereTransform->scaleFactor.setValue(8.0f, 8.0f, 8.0f);
  sphereRoot->addChild(sphereTransform);
  
  sphereMaterial = new SoMaterial;
  sphereMaterial->diffuseColor.setValue(0.8f, 0.8f, 0.8f);
  sphereRoot->addChild(sphereMaterial);
  sphereRoot->addChild(new SoSphere);
  root->addChild(sphereRoot);
  
  // Add a text node
  SoSeparator *textRoot = new SoSeparator;
  SoTransform *textTransform = new SoTransform;
  textTransform->translation.setValue(0.0f, -1.0f, 0.0f);
  textRoot->addChild(textTransform);
  
  textMaterial = new SoMaterial;
  textMaterial->diffuseColor.setValue(0.8f, 0.8f, 0.8f);
  textRoot->addChild(textMaterial);
  SoPickStyle *textPickStyle = new SoPickStyle;
  textPickStyle->style.setValue(SoPickStyle::BOUNDING_BOX);
  textRoot->addChild(textPickStyle);
  SoText3 *myText = new SoText3;
  myText->string = "rhubarb";
  textRoot->addChild(myText);
  root->addChild(textRoot);
  
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  myRenderArea->setSceneGraph(selectionRoot);
  myRenderArea->setTitle("My Selection Callback");
  myRenderArea->show();
  
  // Make the camera see the whole scene
  const SbViewportRegion myViewport = 
    myRenderArea->getViewportRegion();
  myCamera->viewAll(root, myViewport, 2.0f);
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  selectionRoot->deselectAll();

  selectionRoot->unref();

  delete myRenderArea;
  SoXt::finish();

  return 0;
}



