/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*-------------------------------------------------------------
 *  This is an example from The Inventor Mentor,
 *  chapter 10, example 6.
 *
 *  This example demonstrates the use of the pick filter
 *  callback to implement a top level selection policy.
 *  That is, always select the top most group beneath the
 *  selection node,  rather than selecting the actual
 *  shape that was picked.
 *------------------------------------------------------------*/



#ifdef _WIN32
#  include <windows.h>
#elif !defined(__APPLE__)
#  include <X11/StringDefs.h>
#  include <X11/Intrinsic.h>
#endif

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/SoPath.h>
#include <Inventor/SoPickedPoint.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/actions/SoBoxHighlightRenderAction.h>
#include <Inventor/nodes/SoSelection.h>

// Pick the topmost node beneath the selection node
SoPath *
pickFilterCB(void *, const SoPickedPoint *pick)
{    
  // See which child of selection got picked
  SoPath *p = pick->getPath();
  int i;
  for (i = 0; i < p->getLength() - 1; i++) {
    SoNode *n = p->getNode(i);
    if (n->isOfType(SoSelection::getClassTypeId()))
      break;
  }
   
  // Copy 2 nodes from the path:
  // selection and the picked child
  return p->copy(i, 2);
}

int
main(int, char **argv)
{
  // Initialization
  Widget mainWindow = SoXt::init(argv[0]);
    
   // Open the data file
  SoInput in;   
  char *datafile = (char *)"$OIVHOME/examples/data/Inventor/parkbench.iv";
  if (! in.openFile(datafile)) {
    fprintf(stderr, "Cannot open %s for reading.\n", datafile);
    exit(-1);
  }

  // Read the input file
  SoNode *n;
  SoSeparator *sep = new SoSeparator;
  while ((SoDB::read(&in, n) != FALSE) && (n != NULL))
    sep->addChild(n);
   
   // Create two selection roots - one will use the pick filter.
  SoSelection *topLevelSel = new SoSelection;
  topLevelSel->addChild(sep);
  topLevelSel->setPickFilterCallback(pickFilterCB);

  SoSelection *defaultSel = new SoSelection;
  defaultSel->addChild(sep);

  // Create two viewers, one to show the pick filter for top level
  // selection, the other to show default selection.
  SoXtExaminerViewer *viewer1 = new SoXtExaminerViewer(mainWindow);
  viewer1->setSceneGraph(topLevelSel);
  viewer1->setGLRenderAction(new SoBoxHighlightRenderAction());
  viewer1->redrawOnSelectionChange(topLevelSel);
  viewer1->setTitle("Top Level Selection");

  SoXtExaminerViewer *viewer2 = new SoXtExaminerViewer( mainWindow , "" , FALSE);
  viewer2->setSceneGraph(defaultSel);
  viewer2->setGLRenderAction(new SoBoxHighlightRenderAction());    
  viewer2->redrawOnSelectionChange(defaultSel);
  viewer2->setTitle("Default Selection");

  viewer1->show();
  viewer2->show();
   
  SoXt::show(mainWindow);
  SoXt::mainLoop();

  delete viewer1;
  delete viewer2;
  SoXt::finish();

  return 0;
}



