/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*-----------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 11, example 1.
 *
 *  Example of reading from a file.
 *  Read a file given a filename and return a separator
 *  containing all of the file.  Return NULL if there is 
 *  an error reading the file.
 *----------------------------------------------------------*/



#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>


/////////////////////////////////////////////////////////////
// CODE FOR The Inventor Mentor STARTS HERE

SoSeparator *
readFile(const char *filename)
{
  // Open the input file
  SoInput mySceneInput;
  if (!mySceneInput.openFile(filename)) {
    fprintf(stderr, "Cannot open file %s\n", filename);
    return NULL;
  }
  
  // Read the whole file into the database
  SoSeparator *myGraph = SoDB::readAll(&mySceneInput);
  if (myGraph == NULL) {
    fprintf(stderr, "Problem reading file\n");
    return NULL;
  } 
  
  mySceneInput.closeFile();
  return myGraph;
}

// CODE FOR The Inventor Mentor ENDS HERE 
/////////////////////////////////////////////////////////////

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  
  // Read the file
  SoSeparator *scene = readFile("$OIVHOME/data/models/household/plant.iv");

  // Create a viewer
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  
  // attach and show viewer
  myViewer->setSceneGraph(scene);
  myViewer->setTitle("File Reader");
  myViewer->show();
  
  // Loop forever
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myViewer;
  SoXt::finish();

  return 0;
}



