/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 11, example 2.
 *
 *  Example of creatinge a scene graph by reading from a string.
 *  Create a dodecahedron, made of an IndexedFaceSet.  
 *------------------------------------------------------------*/

#include <string.h>


#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>


/////////////////////////////////////////////////////////////
// CODE FOR The Inventor Mentor STARTS HERE

// Reads a dodecahedron from the following string: 
// (Note: ANSI compilers automatically concatenate 
// adjacent string literals together, so the compiler sees 
// this as one big string)

static char *dodecahedron = (char *)
"Separator {"
"   Normal {"
"      vector ["
"         0.553341 0 0.832955, 0.832955 0.553341 0,"
"         0.832955 -0.553341 0, 0 -0.832955 0.553341,"
"         -0.553341 0 0.832955, 0 0.832955 0.553341,"
"         0 0.832955 -0.553341, -0.832955 0.553341 0,"
"         -0.832955 -0.553341 0, 0 -0.832955 -0.553341,"
"         0.553341 0 -0.832955, -0.553341 0 -0.832955,"
"      ]"
"   }"
"   NormalBinding { value PER_FACE }"
"   Material {"
"      diffuseColor ["
"         1  0  0,   0 1  0,   0  0 1,   0  1  1,"
"         1  0  1,  .5 1  0,  .5  0 1,  .5  1  1,"
"         1 .3 .7,  .3 1 .7,  .3 .7 1,  .5 .5 .8"
"      ]"
"   }"
"   MaterialBinding { value PER_FACE }"
"   Coordinate3 {"
"      point ["
"         1.7265 0 0.618,    1 1 1,"
"         0 0.618 1.7265,    0 -0.618 1.7265,"
"         1 -1 1,    -1 -1 1,"
"         -0.618 -1.7265 0,    0.618 -1.7265 0,"
"         1 -1 -1,    1.7265 0 -0.618,"
"         1 1 -1,    0.618 1.7265 0,"
"         -0.618 1.7265 0,    -1 1 1,"
"         -1.7265 0 0.618,    -1.7265 0 -0.618,"
"         -1 -1 -1,    0 -0.618 -1.7265,"
"         0 0.618 -1.7265,    -1 1 -1"
"      ]"
"   }"
"   IndexedFaceSet {"
"      coordIndex ["
"         1, 2, 3, 4, 0, -1,  0, 9, 10, 11, 1, -1,"
"         4, 7, 8, 9, 0, -1,  3, 5, 6, 7, 4, -1,"
"         2, 13, 14, 5, 3, -1,  1, 11, 12, 13, 2, -1,"
"         10, 18, 19, 12, 11, -1,  19, 15, 14, 13, 12, -1,"
"         15, 16, 6, 5, 14, -1,  8, 7, 6, 16, 17, -1,"
"         9, 8, 17, 18, 10, -1,  18, 17, 16, 15, 19, -1,"
"      ]"
"   }"
"}";

// Routine to create a scene graph representing a dodecahedron
SoNode *
makeDodecahedron()
{
  // Read from the string.
  SoInput in;
  in.setBuffer(dodecahedron, strlen(dodecahedron));
  
  SoNode *result;
  SoDB::read(&in, result);
  
  return result;
}

// CODE FOR The Inventor Mentor ENDS HERE
/////////////////////////////////////////////////////////////

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  SoNode *root = makeDodecahedron();
  root->ref();
  
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("String Reader");
  myViewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myViewer;
  root->unref();
  SoXt::finish();

  return 0;
}


