/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 12, example 1.
 *
 *  Sense changes to a viewer's camera's position.
 *------------------------------------------------------------*/

#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/sensors/SoFieldSensor.h>
#include <Inventor/nodes/SoWWWInline.h>

// Callback that reports whenever the viewer's position changes.
static void
cameraChangedCB(void *data, SoSensor *)
{
  SoCamera *viewerCamera = (SoCamera *)data;
  
  SbVec3f cameraPosition = viewerCamera->position.getValue();
  printf("Camera position: (%g,%g,%g)\n",
    cameraPosition[0], cameraPosition[1],
    cameraPosition[2]); 
}

int
main(int argc, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  const char *defaultFileName = "$OIVHOME/data/models/toys/jackInTheBox.iv";

  const char *fileName = 
    (argc >= 2 ? argv[1] : defaultFileName);

  SoInput inputFile;
  if (inputFile.openFile(fileName) == FALSE) {
    fprintf(stderr, "Usage: %s filename.iv\n", argv[0]);
    fprintf(stderr, "Could not open file %s\n", argv[1]);
    exit(1);
  }
  SoWWWInline::setReadAsSoFile(TRUE);
 
  SoSeparator *root = SoDB::readAll(&inputFile);
  root->ref();
  
  SoXtExaminerViewer *myViewer =
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Camera Sensor");
  myViewer->show();
  
  // Get the camera from the viewer, and attach a 
  // field sensor to its position field:
  SoCamera *camera = myViewer->getCamera();
  SoFieldSensor *mySensor = 
    new SoFieldSensor(cameraChangedCB, camera);
  mySensor->attach(&camera->position);
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();

  delete myViewer;
  SoXt::finish();

  return 0;
}


