/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 12, example 2.
 *
 *  Using getTriggerNode/getTriggerField methods of the data
 *  sensor.
 *------------------------------------------------------------*/

#include <Inventor/SoDB.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/sensors/SoNodeSensor.h>

// Sensor callback function:
static void
rootChangedCB(void *, SoSensor *s)
{
  // We know the sensor is really a data sensor:
  SoDataSensor *mySensor = (SoDataSensor *)s;

  SoNode *changedNode = mySensor->getTriggerNode();
  SoField *changedField = mySensor->getTriggerField();

  printf("The node named '%s' changed\n",
         changedNode->getName().getString());

  if (changedField != NULL) {
    SbName fieldName;
    changedNode->getFieldName(changedField, fieldName);
    printf(" (field %s)\n", fieldName.getString());
  }
  else {
    printf(" (no fields changed)\n");
  }
}

int
main(int, char **)
{
  SoDB::init();

  SoSeparator *root = new SoSeparator;
  root->ref();
  root->setName("Root");

  SoCube *myCube = new SoCube;
  root->addChild(myCube);
  myCube->setName("MyCube");

  SoSphere *mySphere = new SoSphere;
  root->addChild(mySphere);
  mySphere->setName("MySphere");

  SoNodeSensor *mySensor = new SoNodeSensor;

  mySensor->setPriority(0);
  mySensor->setFunction(rootChangedCB);
  mySensor->attach(root);

  // Now, make a few changes to the scene graph; the sensor's
  // callback function will be called immediately after each
  // change.
  myCube->width = 1.0;
  myCube->height = 2.0;
  mySphere->radius = 3.0;
  root->removeChild(mySphere);

  SoDB::finish();

  return 0;
}


