/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 12, example 3.
 *
 *  Alarm sensor that raises a flag after 10 minutes
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/sensors/SoAlarmSensor.h>


///////////////////////////////////////////////////////////
// CODE FOR The Inventor Mentor STARTS HERE

static void
raiseFlagCallback(void *data, SoSensor *)
{
  // We know data is really a SoTransform node:
  SoTransform *flagAngleXform = (SoTransform *)data;
  
  // Rotate flag by 90 degrees about the Z axis:
  flagAngleXform->rotation.setValue(SbVec3f(0.0f, 0.0f, 1.0f), 
    (float)(M_PI/2.0f));
}

// CODE FOR The Inventor Mentor ENDS HERE
///////////////////////////////////////////////////////////

int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]); // pass the app name
  if (myWindow == NULL)
    exit(1);
  
  ///////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE
  
  SoTransform *flagXform = new SoTransform;
  
  // Create an alarm that will call the flag-raising callback:
  SoAlarmSensor *myAlarm =
    new SoAlarmSensor(raiseFlagCallback, flagXform);
  myAlarm->setTimeFromNow(5.0f);
  myAlarm->schedule();
  
  // CODE FOR The Inventor Mentor ENDS HERE
  ///////////////////////////////////////////////////////////
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild(flagXform);
  SoCone *myCone = new SoCone;
  myCone->bottomRadius = 0.1f;
  root->addChild(myCone);
  
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  
  // Put our scene in myViewer, change the title
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Raise The Cone");
  myViewer->show();
  
  SoXt::show(myWindow);  // Display main window
  SoXt::mainLoop();      // Main Inventor event loop

  delete myViewer;
  SoXt::finish();

  return 0;
}



