/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 13, example 2.
 *
 *  Global fields.
 *  A digital clock is implemented by connecting the realTime
 *  global field to a Text3 string.
 *------------------------------------------------------------*/


#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoText3.h>


int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);  
  if (myWindow == NULL) exit(1);     
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Add a camera, light, and material
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  SoMaterial *myMaterial = new SoMaterial;
  myMaterial->diffuseColor.setValue(1.0, 0.0, 0.0);   
  root->addChild(myMaterial);
  
  // Create a Text3 object, and connect to the realTime field
  SoText3 *myText = new SoText3;
  root->addChild(myText);
  myText->string.connectFrom(SoDB::getGlobalField("realTime"));
  
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  SbViewportRegion vpr = myRenderArea->getViewportRegion();
  myCamera->viewAll(root, vpr);
  
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("Date & Time");
  myRenderArea->show();
  
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();

  delete myRenderArea;
  SoXt::finish();

  return 0;
}


