/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 13, example 3.
 *
 *  Elapsed time engine.
 *  The output from an elapsed time engine is used to control
 *  the translation of the object.  The resulting effect is
 *  that the figure slides across the scene.
 *------------------------------------------------------------*/



#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/engines/SoCompose.h>
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoRotationXYZ.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoTranslation.h>


int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);  
  if (myWindow == NULL) exit(1);     
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Add a camera and light
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  myCamera->position.setValue(-2.0f, -2.0f, 5.0f);
  myCamera->heightAngle = (float)(M_PI/2.5f); 
  myCamera->nearDistance = 2.0f;
  myCamera->farDistance = 7.0f;
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  
  // Set up transformations
  SoTranslation *slideTranslation = new SoTranslation;
  root->addChild(slideTranslation);
  SoTransform *initialTransform = new SoTransform;
  initialTransform->translation.setValue(-5.0f, 0.0f, 0.0f);
  initialTransform->scaleFactor.setValue(10.0f, 10.0f, 10.0f);
  initialTransform->rotation.setValue(SbVec3f(1.0f, 0.0f, 0.0f), 
    (float)(M_PI/2.0f));
  root->addChild(initialTransform);
  
  // Read the figure object from a file and add to the scene
  SoInput myInput;
  if (!myInput.openFile("$OIVHOME/examples/data/Inventor/jumpyMan.iv")) 
    exit (1);
  SoSeparator *figureObject = SoDB::readAll(&myInput);
  if (figureObject == NULL) exit (1);
  root->addChild(figureObject);
  
  // Make the X translation value change over time.
  SoElapsedTime *myCounter = new SoElapsedTime;
  SoComposeVec3f *slideDistance = new SoComposeVec3f;
  slideDistance->x.connectFrom(&myCounter->timeOut);
  slideTranslation->translation.connectFrom(
    &slideDistance->vector);
  
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("Sliding Man");
  myRenderArea->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myRenderArea;
  SoXt::finish();

  return 0;
}


