/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 13, example 4.
 *
 *  Time counter engine.
 *  The output from an time counter engine is used to control
 *  horizontal and vertical motion of a figure object.
 *  The resulting effect is that the figure jumps across
 *  the screen.
 *------------------------------------------------------------*/



#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/engines/SoCompose.h>
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/engines/SoTimeCounter.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoRotationXYZ.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoTranslation.h>


int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);  
  if (myWindow == NULL) exit(1);     
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Add a camera and light
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  myCamera->position.setValue(-8.0f, -7.0f, 20.0f);
  myCamera->heightAngle = (float)(M_PI/2.5f);
  myCamera->nearDistance = 15.0f;
  myCamera->farDistance = 25.0f;
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  
  //////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE
  
  // Set up transformations
  SoTranslation *jumpTranslation = new SoTranslation;
  root->addChild(jumpTranslation);
  SoTransform *initialTransform = new SoTransform;
  initialTransform->translation.setValue(-20.0f, 0.0f, 0.0f);
  initialTransform->scaleFactor.setValue(40.0f, 40.0f, 40.0f);
  initialTransform->rotation.setValue(SbVec3f(1.0f, 0.0f, 0.0f), 
    (float)(M_PI/2.0f));
  root->addChild(initialTransform);
  
  // Read the man object from a file and add to the scene
  SoInput myInput;
  if (!myInput.openFile("$OIVHOME/examples/data/Inventor/jumpyMan.iv")) 
    exit (1);
  SoSeparator *manObject = SoDB::readAll(&myInput);
  if (manObject == NULL) exit (1);
  root->addChild(manObject);
  
  // Create two counters, and connect to X and Y translations.
  // The Y counter is small and high frequency.
  // The X counter is large and low frequency.
  // This results in small jumps across the screen, 
  // left to right, again and again and again and ....
  SoTimeCounter *jumpHeightCounter = new SoTimeCounter;
  SoTimeCounter *jumpWidthCounter = new SoTimeCounter;
  SoComposeVec3f *jump = new SoComposeVec3f;
  
  jumpHeightCounter->max = 4;
  jumpHeightCounter->frequency = 1.5f;
  jumpWidthCounter->max = 40;
  jumpWidthCounter->frequency = 0.15f;
  
  jump->x.connectFrom(&jumpWidthCounter->output);
  jump->y.connectFrom(&jumpHeightCounter->output);
  jumpTranslation->translation.connectFrom(&jump->vector);
  
  // CODE FOR The Inventor Mentor ENDS HERE
  //////////////////////////////////////////////////////////////
  
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("Jumping Man");
  myRenderArea->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myRenderArea;
  SoXt::finish();

  return 0;
}


