/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 13, example 5.
 *
 *  Gate engine.
 *  Mouse button presses enable and disable a gate engine.
 *  The gate engine controls an elapsed time engine that
 *  controls the motion of the duck.
 *------------------------------------------------------------*/




#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/engines/SoCompose.h>
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/engines/SoGate.h>
#include <Inventor/events/SoMouseButtonEvent.h>
#include <Inventor/nodes/SoCylinder.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoRotationXYZ.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoTranslation.h>

void myMousePressCB(void *, SoEventCallback *);

int
main(int, char **argv)
{
  // Print out usage message
  printf("Click the left mouse button to enable/disable the duck motion\n");
  
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);  
  if (myWindow == NULL) exit(1);     
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Add a camera and light
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  myCamera->position.setValue(0.0f, -4.0f, 8.0f);
  myCamera->heightAngle = (float)(M_PI/2.5f);
  myCamera->nearDistance = 1.0f;
  myCamera->farDistance = 15.0f;
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  
  // Rotate scene slightly to get better view
  SoRotationXYZ *globalRotXYZ = new SoRotationXYZ;
  globalRotXYZ->axis = SoRotationXYZ::X;
  globalRotXYZ->angle = (float)(M_PI/9.0f);
  root->addChild(globalRotXYZ);
  
  // Pond group
  SoSeparator *pond = new SoSeparator; 
  root->addChild(pond);
  SoMaterial *cylMaterial = new SoMaterial;
  cylMaterial->diffuseColor.setValue(0.0f, 0.3f, 0.8f);
  pond->addChild(cylMaterial);
  SoTranslation *cylTranslation = new SoTranslation;
  cylTranslation->translation.setValue(0.0f, -6.725f, 0.0f);
  pond->addChild(cylTranslation);
  SoCylinder *myCylinder = new SoCylinder;
  myCylinder->radius.setValue(4.0f);
  myCylinder->height.setValue(0.5f);
  pond->addChild(myCylinder);
  
  /////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE  (part 1)
  
  // Duck group
  SoSeparator *duck = new SoSeparator;
  root->addChild(duck);
  
  // Read the duck object from a file and add to the group
  SoInput myInput;
  if (!myInput.openFile("$OIVHOME/examples/data/Inventor/duck.iv")) 
    exit (1);
  SoSeparator *duckObject = SoDB::readAll(&myInput);
  if (duckObject == NULL) exit (1);
  
  // Set up the duck transformations
  SoRotationXYZ *duckRotXYZ = new SoRotationXYZ;
  duck->addChild(duckRotXYZ);
  SoTransform *initialTransform = new SoTransform;
  initialTransform->translation.setValue(0.0f, 0.0f, 3.0f);
  initialTransform->scaleFactor.setValue(6.0f, 6.0f, 6.0f);
  duck->addChild(initialTransform);
  
  duck->addChild(duckObject);
  
  // Update the rotation value if the gate is enabled.
  SoGate *myGate = new SoGate(SoMFFloat::getClassTypeId());
  SoElapsedTime *myCounter = new SoElapsedTime;
  myGate->input->connectFrom(&myCounter->timeOut); 
  duckRotXYZ->axis = SoRotationXYZ::Y;  // rotate about Y axis
  duckRotXYZ->angle.connectFrom(myGate->output);
  
  // Add an event callback to catch mouse button presses.
  // Each button press will enable or disable the duck motion.
  SoEventCallback *myEventCB = new SoEventCallback;
  myEventCB->addEventCallback(
    SoMouseButtonEvent::getClassTypeId(),
    myMousePressCB, myGate);
  root->addChild(myEventCB);
  
  // CODE FOR The Inventor Mentor ENDS HERE
  /////////////////////////////////////////////////////////////
  
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("Duck Pond");
  myRenderArea->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myRenderArea;
  SoXt::finish();
  
  return 0;
}

/////////////////////////////////////////////////////////////
// CODE FOR The Inventor Mentor STARTS HERE  (part 2)

// This routine is called for every mouse button event.
void
myMousePressCB(void *userData, SoEventCallback *eventCB)
{
  SoGate *gate = (SoGate *) userData;
  const SoEvent *event = eventCB->getEvent();
  
  // Check for mouse button being pressed
  if (SO_MOUSE_PRESS_EVENT(event, ANY)) {
    
    // Toggle the gate that controls the duck motion
    if (gate->enable.getValue()) 
      gate->enable.setValue(FALSE);
    else 
      gate->enable.setValue(TRUE);
    
    eventCB->setHandled();
  } 
}

// CODE FOR The Inventor Mentor ENDS HERE
/////////////////////////////////////////////////////////////


