/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 13, example 6.
 *
 *  Boolean engine.  Derived from example 13.5.
 *  The smaller duck stays still while the bigger duck moves,
 *  and starts moving as soon as the bigger duck stops.
 *------------------------------------------------------------*/



#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/engines/SoBoolOperation.h>
#include <Inventor/engines/SoCompose.h>
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/engines/SoGate.h>
#include <Inventor/events/SoMouseButtonEvent.h>
#include <Inventor/nodes/SoCylinder.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoRotationXYZ.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoTranslation.h>

void myMousePressCB(void *, SoEventCallback *);

int
main(int, char **argv)
{
  // Print out usage message
  printf("Only one duck can move at a time.\n");
  printf("Click the left mouse button to toggle between the two ducks.\n");
  
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);  
  if (myWindow == NULL) exit(1);     
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Add a camera and light
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  myCamera->position.setValue(0.0f, -4.0f, 8.0f);
  myCamera->heightAngle = (float)(M_PI/2.5f);
  myCamera->nearDistance = 1.0f;
  myCamera->farDistance = 15.0f;
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  
  // Rotate scene slightly to get better view
  SoRotationXYZ *globalRotXYZ = new SoRotationXYZ;
  globalRotXYZ->axis = SoRotationXYZ::X;
  globalRotXYZ->angle = (float)(M_PI/9.0f);
  root->addChild(globalRotXYZ);
  
  // Pond group
  SoSeparator *pond = new SoSeparator; 
  root->addChild(pond);
  SoTranslation *pondTranslation = new SoTranslation;
  pondTranslation->translation.setValue(0.0f, -6.725f, 0.0f);
  pond->addChild(pondTranslation);
  // water
  SoMaterial *waterMaterial = new SoMaterial;
  waterMaterial->diffuseColor.setValue(0.0f, 0.3f, 0.8f);
  pond->addChild(waterMaterial);
  SoCylinder *waterCylinder = new SoCylinder;
  waterCylinder->radius.setValue(4.0f);
  waterCylinder->height.setValue(0.5f);
  pond->addChild(waterCylinder);
  // rock
  SoMaterial *rockMaterial = new SoMaterial;
  rockMaterial->diffuseColor.setValue(0.8f, 0.23f, 0.03f);
  pond->addChild(rockMaterial);
  SoSphere *rockSphere = new SoSphere;
  rockSphere->radius.setValue(0.9f);
  pond->addChild(rockSphere);
  
  // Read the duck object from a file and add to the group
  SoInput myInput;
  if (!myInput.openFile("$OIVHOME/examples/data/Inventor/duck.iv")) 
    exit (1);
  SoSeparator *duckObject = SoDB::readAll(&myInput);
  if (duckObject == NULL) exit (1);
  
  /////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE  
  
  // Bigger duck group
  SoSeparator *bigDuck = new SoSeparator;
  root->addChild(bigDuck);
  SoRotationXYZ *bigDuckRotXYZ = new SoRotationXYZ;
  bigDuck->addChild(bigDuckRotXYZ);
  SoTransform *bigInitialTransform = new SoTransform;
  bigInitialTransform->translation.setValue(0.0f, 0.0f, 3.5f);
  bigInitialTransform->scaleFactor.setValue(6.0f, 6.0f, 6.0f);
  bigDuck->addChild(bigInitialTransform);
  bigDuck->addChild(duckObject);
  
  // Smaller duck group
  SoSeparator *smallDuck = new SoSeparator;
  root->addChild(smallDuck);
  SoRotationXYZ *smallDuckRotXYZ = new SoRotationXYZ;
  smallDuck->addChild(smallDuckRotXYZ);
  SoTransform *smallInitialTransform = new SoTransform;
  smallInitialTransform->translation.setValue(0.0f, -2.24f, 1.5f);
  smallInitialTransform->scaleFactor.setValue(4.0f, 4.0f, 4.0f);
  smallDuck->addChild(smallInitialTransform);
  smallDuck->addChild(duckObject);
  
  // Use a gate engine to start/stop the rotation of 
  // the bigger duck.
  SoGate *bigDuckGate = new SoGate(SoMFFloat::getClassTypeId());
  SoElapsedTime *bigDuckTime = new SoElapsedTime;
  bigDuckGate->input->connectFrom(&bigDuckTime->timeOut); 
  bigDuckRotXYZ->axis = SoRotationXYZ::Y;  // Y axis
  bigDuckRotXYZ->angle.connectFrom(bigDuckGate->output);
  
  // Each mouse button press will enable/disable the gate 
  // controlling the bigger duck.
  SoEventCallback *myEventCB = new SoEventCallback;
  myEventCB->addEventCallback(
    SoMouseButtonEvent::getClassTypeId(),
    myMousePressCB, bigDuckGate);
  root->addChild(myEventCB);
  
  // Use a Boolean engine to make the rotation of the smaller
  // duck depend on the bigger duck.  The smaller duck moves
  // only when the bigger duck is still.
  SoBoolOperation *myBoolean = new SoBoolOperation;
  myBoolean->a.connectFrom(&bigDuckGate->enable);
  myBoolean->operation = SoBoolOperation::NOT_A;
  
  SoGate *smallDuckGate = new SoGate(SoMFFloat::getClassTypeId());
  SoElapsedTime *smallDuckTime = new SoElapsedTime;
  smallDuckGate->input->connectFrom(&smallDuckTime->timeOut); 
  smallDuckGate->enable.connectFrom(&myBoolean->output); 
  smallDuckRotXYZ->axis = SoRotationXYZ::Y;  // Y axis
  smallDuckRotXYZ->angle.connectFrom(smallDuckGate->output);
  
  // CODE FOR The Inventor Mentor ENDS HERE
  /////////////////////////////////////////////////////////////
  
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("Duck and Duckling");
  myRenderArea->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myRenderArea;
  SoXt::finish();

  return 0;
}

// This routine is called for every mouse button event.
void
myMousePressCB(void *userData, SoEventCallback *eventCB)
{
  SoGate *gate = (SoGate *) userData;
  const SoEvent *event = eventCB->getEvent();
  
  // Check for mouse button being pressed
  if (SO_MOUSE_PRESS_EVENT(event, ANY)) {
    
    // Toggle the gate that controls the duck motion
    if (gate->enable.getValue()) 
      gate->enable.setValue(FALSE);
    else 
      gate->enable.setValue(TRUE);
    
    eventCB->setHandled();
  } 
}



