/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 13, example 7.
 *
 *  A calculator engine computes a closed, planar curve.
 *  The output from the engine is connected to the translation
 *  applied to a flower object, which consequently moves
 *  along the path of the curve.
 *------------------------------------------------------------*/




#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/engines/SoCalculator.h>
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/engines/SoTimeCounter.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoRotationXYZ.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoTranslation.h>


int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);  
  if (myWindow == NULL) exit(1);     
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Add a camera and light
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  myCamera->position.setValue(-0.5f, -3.0f, 19.0f);
  myCamera->nearDistance = 10.0f;
  myCamera->farDistance = 26.0f;
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  
  // Rotate scene slightly to get better view
  SoRotationXYZ *globalRotXYZ = new SoRotationXYZ;
  globalRotXYZ->axis = SoRotationXYZ::X;
  globalRotXYZ->angle = (float)(M_PI/7.0f);
  root->addChild(globalRotXYZ);
  
  // Read the background path from a file and add to the group
  SoInput myInput;
  if (!myInput.openFile("$OIVHOME/examples/data/Inventor/flowerPath.iv")) 
    exit (1);
  SoSeparator *flowerPath = SoDB::readAll(&myInput);
  if (flowerPath == NULL) 
    exit(1);
  root->addChild(flowerPath);
  
  /////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE  
  
  // Flower group
  SoSeparator *flowerGroup = new SoSeparator;
  root->addChild(flowerGroup);
  
  // Read the flower object from a file and add to the group
  if (!myInput.openFile("$OIVHOME/examples/data/Inventor/flower.iv")) 
    exit (1);
  SoSeparator *flower= SoDB::readAll(&myInput);
  if (flower == NULL) exit (1);
  
  // Set up the flower transformations
  SoTranslation *danceTranslation = new SoTranslation;
  SoTransform *initialTransform = new SoTransform;
  flowerGroup->addChild(danceTranslation);
  initialTransform->scaleFactor.setValue(10.0f, 10.0f, 10.0f);
  initialTransform->translation.setValue(0.0f, 0.0f, 5.0f);
  flowerGroup->addChild(initialTransform);
  flowerGroup->addChild(flower);
  
  // Set up an engine to calculate the motion path:
  // r = 5*cos(5*theta); x = r*cos(theta); z = r*sin(theta)
  // Theta is incremented using a time counter engine,
  // and converted to radians using an expression in
  // the calculator engine.
  SoCalculator *calcXZ = new SoCalculator; 
  SoTimeCounter *thetaCounter = new SoTimeCounter;
  
  thetaCounter->max = 360;
  thetaCounter->step = 4;
  thetaCounter->frequency = 0.075f;
  
  calcXZ->a.connectFrom(&thetaCounter->output);    
  calcXZ->expression.set1Value(0, "ta=a*M_PI/180"); // theta
  calcXZ->expression.set1Value(1, "tb=5*cos(5*ta)"); // r
  calcXZ->expression.set1Value(2, "td=tb*cos(ta)"); // x 
  calcXZ->expression.set1Value(3, "te=tb*sin(ta)"); // z 
  calcXZ->expression.set1Value(4, "oA=vec3f(td,0,te)"); 
  danceTranslation->translation.connectFrom(&calcXZ->oA);
  
  // CODE FOR The Inventor Mentor ENDS HERE
  /////////////////////////////////////////////////////////////
  
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("Flower Dance");
  myRenderArea->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myRenderArea;
  SoXt::finish();

  return 0;
}



