/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 13, example 8.
 *
 *  Rotor node example.  
 *  Read in the tower and vanes of a windmill from a file.
 *  Use a rotor node to rotate the vanes.
 *------------------------------------------------------------*/



#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoRotor.h>


SoSeparator *
readFile(const char *filename)
{
  // Open the input file
  SoInput mySceneInput;
  if (!mySceneInput.openFile(filename)) {
    fprintf(stderr, "Cannot open file %s\n", filename);
    return NULL;
  }
  
  // Read the whole file into the database
  SoSeparator *myGraph = SoDB::readAll(&mySceneInput);
  if (myGraph == NULL) {
    fprintf(stderr, "Problem reading file\n");
    return NULL;
  } 
  
  mySceneInput.closeFile();
  return myGraph;
}

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Read in the data for the windmill tower
  SoSeparator *windmillTower = 
    readFile("$OIVHOME/examples/data/Inventor/windmillTower.iv");
  root->addChild(windmillTower);
  
  // Add a rotor node to spin the vanes
  SoRotor *myRotor = new SoRotor;
  myRotor->rotation.setValue(SbVec3f(0.0f, 0.0f, 1.0f), 
    (float)(M_PI/32.0f)); // z axis
  myRotor->speed = 0.1f;
  root->addChild(myRotor);
  
  // Read in the data for the windmill vanes
  SoSeparator *windmillVanes = 
    readFile("$OIVHOME/examples/data/Inventor/windmillVanes.iv");
  root->addChild(windmillVanes);
  
  // Create a viewer
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  
  // attach and show viewer
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Windmill");
  myViewer->show();
  
  // Loop forever
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myViewer;
  SoXt::finish();

  return 0;
}



