/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 13, example 8.
 *
 *  Blinker node.
 *  Use a blinker node to flash a neon ad sign on and off
 *------------------------------------------------------------*/




#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/nodes/SoBlinker.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoText3.h>


int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);  
  if (myWindow == NULL) exit(1);     
  
  // Set up camera and light
  SoSeparator *root = new SoSeparator;
  root->ref();
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  
  // Read in the parts of the sign from a file
  SoInput myInput;
  if (!myInput.openFile("$OIVHOME/examples/data/Inventor/eatAtJosies.iv")) 
    exit (1);
  SoSeparator *fileContents = SoDB::readAll(&myInput);
  if (fileContents == NULL) exit (1);
  fileContents->ref();
  
  SoSeparator *eatAt;
  eatAt = (SoSeparator *)SoNode::getByName("EatAt");
  SoSeparator *josie;
  josie = (SoSeparator *)SoNode::getByName("Josies");
  SoSeparator *frame;
  frame = (SoSeparator *)SoNode::getByName("Frame");
  
  //////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE
  
  // Add the non-blinking part of the sign to the root
  root->addChild(eatAt);
  
  // Add the fast-blinking part to a blinker node
  SoBlinker *fastBlinker = new SoBlinker;
  root->addChild(fastBlinker);
  fastBlinker->speed = 2;  // blinks 2 times a second
  fastBlinker->addChild(josie);
  
  // Add the slow-blinking part to another blinker node
  SoBlinker *slowBlinker = new SoBlinker;
  root->addChild(slowBlinker);
  slowBlinker->speed = 0.5;  // 2 secs per cycle; 1 on, 1 off
  slowBlinker->addChild(frame);
  
  // CODE FOR The Inventor Mentor ENDS HERE
  //////////////////////////////////////////////////////////////
  
  // Set up and display render area 
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  SbViewportRegion myRegion(myRenderArea->getSize()); 
  myCamera->viewAll(root, myRegion);
  
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("Neon");
  myRenderArea->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();

  fileContents->unref();
  root->unref();

  delete myRenderArea;
  SoXt::finish();

  return 0;
}


