/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*----------------------------------------------------------------
 *  This is an example from the Inventor Mentor.
 *  chapter 14, example 1.
 *
 *  Use SoShapeKits to create two 3-D words, "NICE" and "HAPPY"
 *  Use nodekit methods to access the fields of the "material"
 *  and "transform" parts.
 *  Use a calculator engine and an elapsed time engine to make
 *  the words change color and fly about the screen.
 *----------------------------------------------------------------*/


#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/engines/SoCalculator.h>
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/nodekits/SoShapeKit.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoText3.h>
#include <Inventor/nodes/SoTransform.h>


int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Create shape kits with the words "HAPPY" and "NICE"
  SoShapeKit *happyKit = new SoShapeKit;
  root->addChild(happyKit);
  happyKit->setPart("shape", new SoText3);
  happyKit->set((char*)"shape { parts ALL string \"HAPPY\"}");
  happyKit->set((char*)"font { size 2}");
  
  SoShapeKit *niceKit = new SoShapeKit;
  root->addChild(niceKit);
  niceKit->setPart("shape", new SoText3);
  niceKit->set((char*)"shape { parts ALL string \"NICE\"}");
  niceKit->set((char*)"font { size 2}");
  
  // Create the Elapsed Time engine
  SoElapsedTime *myTimer = new SoElapsedTime;
  myTimer->ref();
  
  // Create two calculator - one for HAPPY, one for NICE.
  SoCalculator *happyCalc = new SoCalculator;
  happyCalc->ref();
  happyCalc->a.connectFrom(&myTimer->timeOut);
  happyCalc->expression = "ta=cos(2*a); tb=sin(2*a);\
                                                      oA = vec3f(3*pow(ta,3),3*pow(tb,3),1);         \
                                                      oB = vec3f(fabs(ta)+.1,fabs(.5*fabs(tb))+.1,1);\
                                                      oC = vec3f(fabs(ta),fabs(tb),.5)";
  
  // The second calculator uses different arguments to
  // sin() and cos(), so it moves out of phase.
  SoCalculator *niceCalc = new SoCalculator;
  niceCalc->ref();
  niceCalc->a.connectFrom(&myTimer->timeOut);
  niceCalc->expression = "ta=cos(2*a+2); tb=sin(2*a+2);\
                                                         oA = vec3f(3*pow(ta,3),3*pow(tb,3),1);            \
                                                         oB = vec3f(fabs(ta)+.1,fabs(.5*fabs(tb))+.1,1);   \
                                                         oC = vec3f(fabs(ta),fabs(tb),.5)";
  
  // Connect the transforms from the calculators...
  SoTransform *happyXf = happyKit->getPart<SoTransform>( "transform" );
  happyXf->translation.connectFrom(&happyCalc->oA);
  happyXf->scaleFactor.connectFrom(&happyCalc->oB);
  SoTransform* niceXf = niceKit->getPart<SoTransform>( "transform" );
  niceXf->translation.connectFrom(&niceCalc->oA);
  niceXf->scaleFactor.connectFrom(&niceCalc->oB);
  
  // Connect the materials from the calculators...
  SoMaterial *happyMtl = happyKit->getPart<SoMaterial>( "material" );
  happyMtl->diffuseColor.connectFrom(&happyCalc->oC);
  SoMaterial *niceMtl = niceKit->getPart<SoMaterial>( "material" );
  niceMtl->diffuseColor.connectFrom(&niceCalc->oC);
  
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Frolicking Words");
  myViewer->viewAll();
  myViewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();

  delete myViewer;
  SoXt::finish();

  return 0;
}


