/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*----------------------------------------------------------------
 *  This is an example from the Inventor Mentor.
 *  chapter 15, example 1.
 *
 *  Uses an SoTranslate1Dragger to control the bottomRadius field 
 *  of an SoCone.  The 'translation' field of the dragger is the 
 *  input to an SoDecomposeVec3f engine. The engine extracts the
 *  x component from the translation. This extracted value is
 *  connected to the bottomRadius field of the cone.
 *----------------------------------------------------------------*/

#include <Inventor/engines/SoCompose.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/draggers/SoTranslate1Dragger.h>


#define myAbs(x) ((x) < 0 ? -(x) : (x))

int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL)
    exit(1);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // Create myDragger with an initial translation of (1, 0, 0)
  SoTranslate1Dragger *myDragger = new SoTranslate1Dragger;
  root->addChild(myDragger);
  myDragger->translation.setValue(1, 0, 0);
  
  // Place an SoCone above myDragger
  SoTransform *myTransform = new SoTransform;
  SoCone *myCone = new SoCone;
  root->addChild(myTransform);
  root->addChild(myCone);
  myTransform->translation.setValue(0, 3, 0);
  
  // SoDecomposeVec3f engine extracts myDragger's x-component
  // The result is connected to myCone's bottomRadius.
  SoDecomposeVec3f *myEngine = new SoDecomposeVec3f;
  myEngine->vector.connectFrom(&myDragger->translation);
  myCone->bottomRadius.connectFrom(&(myEngine->x));
  
  // Display them in a viewer
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Dragger Edits Cone Radius");
  myViewer->viewAll();
  myViewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myViewer;
  SoXt::finish();
  
  return 0;
}


