/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 16, example 3.
 *
 *  This example builds a render area in a window supplied by
 *  the application and a Material Editor in its own window.
 *  It attaches the editor to the material of an object.
 *-----------------------------------------------------------*/



#include <Inventor/Xt/SoXtMaterialEditor.h>

#include <Inventor/SoDB.h>         
#include <Inventor/Xt/SoXt.h>         
#include <Inventor/Xt/SoXtRenderArea.h>  
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>


int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
   
  // Build the render area in the applications main window
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  myRenderArea->setSize(SbVec2s(200, 200));
   
  // Build the material editor in its own window
  SoXtMaterialEditor *myEditor = 
    new SoXtMaterialEditor(NULL, "Material Editor", FALSE);
   
  // Create a scene graph
  SoSeparator *root = new SoSeparator;
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  SoMaterial *myMaterial = new SoMaterial;
   
  root->ref();
  myCamera->position.setValue(0.212482f, -0.881014f, 2.5f);
  myCamera->heightAngle = (float)(M_PI/4.0f);
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  root->addChild(myMaterial);

  // Read the geometry from a file and add to the scene
  SoInput myInput;
  if (!myInput.openFile("$OIVHOME/examples/data/Inventor/dogDish.iv"))
    exit (1);
  SoSeparator *geomObject = SoDB::readAll(&myInput);
  if (geomObject == NULL)
    exit (1);
  root->addChild(geomObject);
   
  // Set the scene graph 
  myRenderArea->setSceneGraph(root);
   
  // Attach material editor to the material
  myEditor->attach(myMaterial);
   
  // Show the application window and the material editor
  myRenderArea->setTitle("Attach Editor");
  myRenderArea->show();
  SoXt::show(myWindow);
  myEditor->show();

  // Loop forever
  SoXt::mainLoop();

  delete myEditor;
  delete myRenderArea;
  SoXt::finish();

  return 0;
}


