/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*-------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 16, example 4.
 *
 *  This example builds a render area and Material Editor within 
 *  a window supplied by the application. It uses a Motif form 
 *  widget to lay both components inside the same window.  
 *  It attaches the editor to the material of an object.
 *-----------------------------------------------------------*/



#include <Xm/Form.h>
#include <Inventor/SoDB.h>          
#include <Inventor/Xt/SoXt.h>          
#include <Inventor/Xt/SoXtMaterialEditor.h>
#include <Inventor/Xt/SoXtRenderArea.h>  
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h> 

int
main(int , char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]);
   
   // Build the form to hold both components
   Widget myForm = XtCreateWidget("Form", 
            xmFormWidgetClass, myWindow, NULL, 0);
   
   // Build the render area and Material Editor
   SoXtRenderArea *myRenderArea = new SoXtRenderArea(myForm);
   myRenderArea->setSize(SbVec2s(200, 200));
   SoXtMaterialEditor *myEditor = 
            new SoXtMaterialEditor(myForm);
   
   // Layout the components within the form
   Arg  args[8];
   XtSetArg(args[0], XmNtopAttachment,    XmATTACH_FORM);
   XtSetArg(args[1], XmNbottomAttachment, XmATTACH_FORM);
   XtSetArg(args[2], XmNleftAttachment,   XmATTACH_FORM); 
   XtSetArg(args[3], XmNrightAttachment,  XmATTACH_POSITION);
   XtSetArg(args[4], XmNrightPosition,    40);
   XtSetValues(myRenderArea->getWidget(), args, 5);
   XtSetArg(args[2], XmNrightAttachment,  XmATTACH_FORM); 
   XtSetArg(args[3], XmNleftAttachment,   XmATTACH_POSITION);
   XtSetArg(args[4], XmNleftPosition,     41); 
   XtSetValues(myEditor->getWidget(), args, 5);
   
   // Create a scene graph
   SoSeparator *root = new SoSeparator;
   SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
   SoMaterial *myMaterial = new SoMaterial;
   
   root->ref();
   myCamera->position.setValue(0.212482F, -0.881014F, 2.5F);
   myCamera->heightAngle = (float)(M_PI / 4.0);
   root->addChild(myCamera);
   root->addChild(new SoDirectionalLight);
   root->addChild(myMaterial);

   // Read the geometry from a file and add to the scene
   SoInput myInput;
   if (!myInput.openFile("$OIVHOME/examples/data/Inventor/dogDish.iv"))
      exit (1);
   SoSeparator *geomObject = SoDB::readAll(&myInput);
   if (geomObject == NULL)
      exit (1);
   root->addChild(geomObject);
   
   // Make the scene graph visible
   myRenderArea->setSceneGraph(root);
   
   // Attach the material editor to the material in the scene
   myEditor->attach(myMaterial);
   
   // Show the main window
   myRenderArea->show();
   myEditor->show();
   SoXt::show(myForm);    // this calls XtManageChild
   SoXt::show(myWindow);  // this calls XtRealizeWidget
   
   // Loop forever
   SoXt::mainLoop();

   delete myRenderArea;
   SoXt::finish();

   return 0;
}


