/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

/*------------------------------------------------------------
 *  This is an example from the Inventor Mentor
 *  chapter 16, example 5.
 *
 *  This example creates a simple scene graph and attaches a
 *  browser Examiner viewer to view the data. The camera and
 *  light in the scene are automatically created by the viewer.
 *-----------------------------------------------------------*/



#include <Inventor/SoDB.h>         
#include <Inventor/Xt/SoXt.h>         
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>  
#include <Inventor/nodes/SoSeparator.h>

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  
  // Build the viewer in the applications main window
  SoXtExaminerViewer *myViewer = 
    new SoXtExaminerViewer(myWindow);
  
  // Read the geometry from a file and add to the scene
  SoInput myInput;
  if (!myInput.openFile("$OIVHOME/examples/data/Inventor/dogDish.iv"))
    exit (1);
  SoSeparator *geomObject = SoDB::readAll(&myInput);
  if (geomObject == NULL)
    exit (1);
  
  // Attach the viewer to the scene graph
  myViewer->setSceneGraph(geomObject);
  
  // Show the main window
  myViewer->show();
  SoXt::show(myWindow);
  
  // Loop forever
  SoXt::mainLoop();
  delete myViewer;
  SoXt::finish();  
  
  return 0;
}


