/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*------------------------------------------------------------
 *  This is an example from The Inventor Mentor
 *  chapter 17, example 1.
 *
 *  This examples shows how the user can create a custom
 *  X visual for doing color index rendering with
 *  an Inventor Viewer. This shows how to create the right
 *  visual, as well as load the color map with the wanted
 *  colors.
 *-----------------------------------------------------------*/

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/nodes/SoNode.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/sys/SoGLX.h>

// window attribute list to create a color index visual.
// This will create a double buffered color index window
// with the maximum number of bits and a zbuffer.
int attribList[] = {
  GLX_RGBA,
  GLX_DOUBLEBUFFER,
  GLX_BUFFER_SIZE, 1,
  GLX_DEPTH_SIZE, 1,
  None
};

// list of colors to load in the color map
static float colors[3][3] = {
  {0.2F, 0.2F, 0.2F},
  {0.5F, 1.0F, 0.5F},
  {0.5F, 0.5F, 1.0F}
};

static const char *sceneBuffer = "\
#Inventor V2.0 ascii\n\
\
Separator { \
  LightModel { model BASE_COLOR } \
  ColorIndex { index 1 } \
  Coordinate3 { point [ -1 -1 -1, -1 1 -1, 1 1 1, 1 -1 1] } \
  FaceSet {} \
  ColorIndex { index 2 } \
  Coordinate3 { point [ -1 -1 1, -1 1 1, 1 1 -1, 1 -1 -1] } \
  FaceSet {} \
} ";

int
main(int , char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  
  // read the scene graph in
  SoInput in;
  SoNode *scene;
  in.setBuffer((void *)sceneBuffer, (size_t) strlen(sceneBuffer));
  if (! SoDB::read(&in, scene) || scene == NULL) {
    printf("Couldn't read scene\n");
    exit(1);
  }
  
  // create the color index visual
  XVisualInfo *vis = glXChooseVisual(XtDisplay(myWindow),
    XScreenNumberOfScreen(XtScreen(myWindow)), attribList);
  if (! vis) {
    printf("Couldn't create visual\n");
    exit(1);
  }
  
  // allocate the viewer, set the scene, the visual and
  // load the color map with the wanted colors.
  //
  // Color 0 will be used for the background (default) while
  // color 1 and 2 are used by the objects.
  //
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setNormalVisual(vis);
  myViewer->setColorMap(0, 3, (SbColor *)colors);
  myViewer->setSceneGraph(scene);
  myViewer->setTitle("Color Index Mode");
  
  // Show the viewer and loop forever...
  myViewer->show();
  XtRealizeWidget(myWindow);
  SoXt::mainLoop();

  delete myViewer;
  SoXt::finish();
  
  return 0;
}


