/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*------------------------------------------------------------
 *  This is an example from The Inventor Mentor,
 *  chapter 17, example 2.
 *
 *  Example of combining Inventor and OpenGL rendering.
 *  Create an Inventor render area and draw a red cube 
 *  and a blue sphere.  Render the floor with OpenGL 
 *  through a Callback node.
 *----------------------------------------------------------*/

#include <Inventor/SbLinear.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/sys/SoGL.h>
#include <Inventor/nodes/SoGLCallback.h>


float floorObj[81][3];

// Build a scene with two objects and some light
void
buildScene(SoGroup *root)
{
  // Some light
  root->addChild(new SoLightModel);
  root->addChild(new SoDirectionalLight);
  
  // A red cube translated to the left and down
  SoTransform *myTrans = new SoTransform;    
  myTrans->translation.setValue(-2.0, -2.0, 0.0);
  root->addChild(myTrans);
  
  SoMaterial *myMtl = new SoMaterial;
  myMtl->diffuseColor.setValue(1.0, 0.0, 0.0);
  root->addChild(myMtl);
  
  root->addChild(new SoCube);
  
  // A blue sphere translated right
  myTrans = new SoTransform;    
  myTrans->translation.setValue(4.0, 0.0, 0.0);
  root->addChild(myTrans);
  
  myMtl = new SoMaterial;
  myMtl->diffuseColor.setValue(0.0, 0.0, 1.0);
  root->addChild(myMtl);
  
  root->addChild(new SoSphere);
}

// Build the floor that will be rendered using OpenGL.
void
buildFloor()
{
  int a = 0;
  
  for (float i = -5.0; i <= 5.0; i += 1.25) {
    for (float j = -5.0; j <= 5.0; j += 1.25, a++) {
      floorObj[a][0] = j;
      floorObj[a][1] = 0.0;
      floorObj[a][2] = i;
    }
  }
}

// Draw the lines that make up the floor, using OpenGL
void
drawFloor()
{
  int i;
  
  glBegin(GL_LINES);
  for (i=0; i<4; i++) {
    glVertex3fv(floorObj[i*18]);
    glVertex3fv(floorObj[(i*18)+8]);
    glVertex3fv(floorObj[(i*18)+17]);
    glVertex3fv(floorObj[(i*18)+9]);
  }
  
  glVertex3fv(floorObj[i*18]);
  glVertex3fv(floorObj[(i*18)+8]);
  glEnd();
  
  glBegin(GL_LINES);
  for (i=0; i<4; i++) {
    glVertex3fv(floorObj[i*2]);
    glVertex3fv(floorObj[(i*2)+72]);
    glVertex3fv(floorObj[(i*2)+73]);
    glVertex3fv(floorObj[(i*2)+1]);
  }
  glVertex3fv(floorObj[i*2]);
  glVertex3fv(floorObj[(i*2)+72]);
  glEnd();
}

// Callback routine to render the floor using OpenGL
void
glCallbackRoutine(void *, SoAction* /*action*/)
{
  glPushMatrix();
  glTranslatef(0.0f, -3.0f, 0.0f);
  glColor3f(0.0f, 0.7f, 0.0f);
  glLineWidth(2);
  glDisable(GL_LIGHTING);  // so we don't have to set normals
  drawFloor();
  glEnable(GL_LIGHTING);   
  glLineWidth(1);
  glPopMatrix(); 
}

int
main(int, char **)
{
  // Initialize Inventor utilities
  Widget myWindow = SoXt::init("Example 17.2");
  
  buildFloor();
  
  // Build a simple scene graph, including a camera and
  // a SoCallback node for performing some GL rendering.
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  myCamera->position.setValue(0.0f, 0.0f, 5.0f);
  myCamera->heightAngle = (float)(M_PI/2.0f);  // 90 degrees
  myCamera->nearDistance = 2.0f;
  myCamera->farDistance = 12.0f;
  root->addChild(myCamera);
  
  SoGLCallback *glCallback = new SoGLCallback;
  glCallback->setCallback(glCallbackRoutine);
  root->addChild(glCallback);
  
  buildScene(root);
  
  // Initialize an Inventor Xt RenderArea and draw the scene.
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("OpenGL Callback");
  myRenderArea->setBackgroundColor(SbColor(0.8f, 0.8f, 0.8f));
  myRenderArea->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myRenderArea;
  SoXt::finish();

  return 0;
}


