/*=================================================================================
 ***     THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),    ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                 ***
 ***                                                                            ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS   ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR   ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                       ***
 ***                                                                            ***
 ***                        RESTRICTED RIGHTS LEGEND                            ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS  ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN  ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT  ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN  ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         ***
 ***                                                                            ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                    ***
 ***                              BORDEAUX, FRANCE                              ***
 ***                            ALL RIGHTS RESERVED                             ***
 =================================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <DialogViz/SoDialogVizAll.h>
#include <DialogViz/dialog/SoDialogViz.h>
#include <Inventor/SoInput.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoComplexity.h>

#include "Torus.h"

int
main( int /*argc*/, char** argv )
{
  Widget window = SoXt::init( argv[0] );
  if ( window == NULL )
    exit( 1 );

  SoDialogViz::init();
  Torus::initClass();

  SoInput* sceneInput = new SoInput;
  sceneInput->openFile( "$OIVHOME/examples/source/Inventor/A_GettingStarted/ToolMaker/02.Nodes/TorusScene.iv" );
  SoRef<SoSeparator> sceneRoot = SoDB::readAll( sceneInput );

  SoTopLevelDialog* dialogRoot = static_cast<SoTopLevelDialog*>( SoDialogViz::loadFromFile("$OIVHOME/examples/source/Inventor/A_GettingStarted/ToolMaker/02.Nodes/TorusDialog.iv") );

  // Get sliders from dialog
  SoDialogRealSlider* radiusSlider = static_cast<SoDialogRealSlider*>( dialogRoot->searchForAuditorId("TORUS_RADIUS") );
  SoDialogRealSlider* minorRadiusSlider = static_cast<SoDialogRealSlider*>( dialogRoot->searchForAuditorId("TORUS_MINOR_RADIUS") );
  SoDialogRealSlider* complexitySlider = static_cast<SoDialogRealSlider*>( dialogRoot->searchForAuditorId("TORUS_COMPLEXITY") );

  // Get torus and complexity from scene
  Torus* torus = static_cast<Torus*>( sceneRoot->getByName("TORUS") );
  SoComplexity* complexity = static_cast<SoComplexity*>( sceneRoot->getByName("COMPLEXITY") );

  dialogRoot->buildDialog( window, true );

  // Link sliders with torus and complexity fields
  torus->radius.connectFrom( &radiusSlider->value );
  torus->minorRadius.connectFrom( &minorRadiusSlider->value );
  complexity->value.connectFrom( &complexitySlider->value );

  // Set up viewer:
  SoWidget viewerWidget =  static_cast<SoDialogCustom*>( dialogRoot->searchForAuditorId("VIEWER") )->getWidget();
  SoXtExaminerViewer* viewer = new SoXtExaminerViewer( viewerWidget );
  viewer->setSceneGraph( sceneRoot.ptr() );
  viewer->setTitle( "Torus" );
  viewer->show();
  viewer->viewAll();

  SoXt::show( window );
  SoXt::mainLoop();

  delete viewer;

  dialogRoot = NULL;
  sceneRoot = NULL;

  Torus::exitClass();

  SoDialogViz::finish();
  SoXt::finish();
  return EXIT_SUCCESS;
}
