/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 2, example 7.
 *
 *  This program initializes the node classes from the previous
 *  examples, reads a scene graph from "newNodes.iv",
 *  writes the graph to stdout, and renders the graph in an
 *  examiner viewer.
 *------------------------------------------------------------*/

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/nodes/SoSeparator.h>

// Header files for new node classes
#include "Glow.h"
#include "Pyramid.h"
#include "Alternate.h"



int
main(int, char **argv)
{
  SoInput      myInput;
  SoSeparator  *root;
  
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  // Initialize the new node classes
  Glow::initClass();
  Pyramid::initClass();
  Alternate::initClass();
  
  if (! myInput.openFile("$OIVHOME/examples/source/Inventor/A_GettingStarted/ToolMaker/02.Nodes/newNodes.iv")) {
    fprintf(stderr, "Can't open \"newNodes.iv\"\n");
    exit(1);
  }
  
  root = SoDB::readAll(&myInput);
  if (root == NULL) {
    printf("File \"$OIVHOME/examples/source/Inventor/A_GettingStarted/ToolMaker/02.Nodes/newNodes.iv\" contains bad data\n");
    exit(2);
  }
  
  root->ref();
  
  // Write the graph to stdout
  SoWriteAction wa;
  wa.apply(root);
  
  // Render it
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTransparencyType(SoGLRenderAction::SORTED_OBJECT);
  myViewer->setTitle("NewNodes");
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();

  delete myViewer;

  Glow::exitClass();
  Pyramid::exitClass();
  Alternate::exitClass();

  SoXt::finish();

  return 0;
}


