/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 2, example 5.
 *
 *  Header file for "Alternate" group node.
 *------------------------------------------------------------*/

#ifndef ALTERNATE_H
#define ALTERNATE_H

#include <Inventor/nodes/SoGroup.h>
// SoGroup.h includes SoSubNode.h; no need to include it again

#if defined(BUILDING_DLL)
#include <Inventor/sys/port.h>
#if defined(_WIN32)
   // When building the node as a DLL under Win32 we must explicitly
   // declare this entry point as visible outside the DLL.  The macro
   // BUILDING_DLL is defined in the node's source file.
#define CUSTOMAPI VC_DLL_EXPORT
#else
#define CUSTOMAPI GCC_DLLEXPORT
#endif
#else
#define CUSTOMAPI
#endif

class CUSTOMAPI Alternate : public SoGroup {

   SO_NODE_HEADER(Alternate);

 public:
   // Initializes this class
   static void   initClass();
   static void   exitClass();

   // Default constructor
   Alternate();

   // Constructor that takes approximate number of children as
   // a hint
   Alternate(int numChildren);

 protected:
   // Generic traversal of children for any action
   virtual void  doAction(SoAction *action);

   virtual void   callback(SoCallbackAction *action);

   // These implement supported actions
   virtual void  getBoundingBox(SoGetBoundingBoxAction *action);
   virtual void  GLRender(SoGLRenderAction *action);
   virtual void  handleEvent(SoHandleEventAction *action);
   virtual void  pick(SoPickAction *action);
   virtual void  getMatrix(SoGetMatrixAction *action);
   virtual void  search(SoSearchAction *action);

 private:
   // Destructor
   virtual ~Alternate();
};

#endif /* ALTERNATE_H */
