/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 2, example 2.
 *
 *  Source file for "Glow" property node.
 *
 *  Note: This is the Win32 DLL version.
 *------------------------------------------------------------*/

#include <Inventor/actions/SoCallbackAction.h>
#include <Inventor/actions/SoGLRenderAction.h>
#include <Inventor/elements/SoLazyElement.h>
#include <Inventor/elements/SoOverrideElement.h>

// This define causes the declaration of initClass in the node's
// header file to be declared _declspec(dllexport).  This is required
// for the entry point to be visible outside the DLL.
#define BUILDING_DLL

#include "Glow.h"

SO_NODE_SOURCE(Glow);

//
// Initializes the Glow class. This is a one-time thing that is
// done after database initialization and before any instance of
// this class is constructed.
//

void
Glow::initClass()
{
   // Initialize type id variables. The arguments to the macro
   // are: the name of the node class, the class this is derived
   // from, and the name registered with the type of the parent
   // class.
   getClassRenderEngineMode().setRenderMode(SbRenderEngineMode::OIV_OPENINVENTOR_RENDERING);
   SO_NODE_INIT_CLASS(Glow, SoNode, "Node");
}

void
Glow::exitClass()
{
   SO__NODE_EXIT_CLASS(Glow);
}


//
// Constructor
//

Glow::Glow()
{
   // Do standard constructor stuff
   SO_NODE_CONSTRUCTOR(Glow);

   // Add "color" field to the field data. The default value for
   // this field is R=G=B=1, which is white
   SO_NODE_ADD_FIELD(color, (1.0, 1.0, 1.0));

   // Add "brightness" field to the field data. The default
   // value for this field is 0.
   SO_NODE_ADD_FIELD(brightness, (0.0));
   
   // Add "transparency" field to the field data.  Default value is 
   // 0 (opaque)
   SO_NODE_ADD_FIELD(transparency,  (0.0));
   
   // Initialize the color Packer (required of any property node that
   // uses an SoColorPacker to set diffuse color or transparency:
   colorPacker = new SoColorPacker;
   
}

//
// Destructor
//

Glow::~Glow()
{
    //  Delete the color Packer:
    delete colorPacker;
}

//
// Implements GL render action.
//

void
Glow::GLRender(SoGLRenderAction *action)
{
   // Set the elements in the state correctly. Note that we
   // prefix the call to doAction() with the class name. This
   // avoids problems if someone derives a new class from the
   // Glow node and inherits the GLRender() method; Glow's
   // doAction() will still be called in that case.
   Glow::doAction(action);

   //  Note that in Inventor 2.1 the GLRender method only sets the color in
   //  the lazy element, does not send it to GL.  This is for efficiency, since
   //  there is no need to send it until it is really used.

}

//
// Implements callback action.
//

void
Glow::callback(SoCallbackAction *action)
{
   // Set the elements in the state correctly
   Glow::doAction(action);
}

//
// Typical action implementation - it sets the correct element
// in the action's traversal state. We assume that the lazy element
// has been enabled.
//

void
Glow::doAction(SoAction *action)
{
   // Make sure the "brightness" field is not ignored. If it is,
   // then we don't need to change anything in the state.
   
   // Also check that the emissive color is not being overridden; if it is
   // this node should not set it.
   
   if (! brightness.isIgnored() && 
        ! SoOverrideElement::getEmissiveColorOverride(action->getState())) {

       SbColor emissiveColor = color.getValue() * brightness.getValue();

       //Use the Lazy element to set emissive color. 
       //Note that this will not actually send the color to GL.       
       SoLazyElement::setEmissive(action->getState(), this, emissiveColor);
       
   }
   
   // To send transparency we again check ignore flag and override element.
 
   if (! transparency.isIgnored() &&
	! SoOverrideElement::getTransparencyOverride(action->getState())) {
   
	// keep a copy of the transparency that we are putting in the state:
	transpValue = transparency.getValue();
	
	// The color packer must be provided when the transparency is set,
	// so that the transparency will be merged with current diffuse color
	// in the state:
	SoLazyElement::setTransparency(action->getState(), this, 1, 
	    &transpValue,  colorPacker);
	    
    } 
}


