/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 3, example 4.
 *
 *  Source file for "MFDouble" field.
 *------------------------------------------------------------*/

#include "MFDouble.h"

// Defines all required member variables and functions for a
// multiple-value field. We use the version that allocates field
// value storage with malloc(), since there is no constructor to
// call for our values.
SO_MFIELD_SOURCE_MALLOC(MFDouble, double, double);

//
// Initializes the class, setting up runtime type info.
//

void
MFDouble::initClass()
{
   // This macro takes the name of the class and the name of the
   // parent class
   SO_MFIELD_INIT_CLASS(MFDouble, SoMField);
}

void
MFDouble::exitClass()
{
   SO_MFIELD_EXIT_CLASS(MFDouble);
}

//
// This reads one value of the double-precision field from a
// file. It is passed the index of the value to read; we can
// assume that the field already contains enough room to hold
// this value. It returns FALSE if the value could not be read
// successfully.
//

SbBool
MFDouble::read1Value(SoInput *in, int index)
{
   // Read a double from the input
   return in->read(values[index]);
}

//
// This writes one value of a double-precision field to a
// file.
//

void
MFDouble::write1Value(SoOutput *out, int index) const
{
   // Write a double
   out->write(values[index]);
}

//
// Returns number of ASCII values to write out per line.
//

int
MFDouble::getNumValuesPerLine() const
{
   // We can probably fit 4 doubles per line pretty easily.
   return 4;
}


