/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 3, example 2.
 *
 *  Source file for "SFDouble" field.
 *------------------------------------------------------------*/

#include "SFDouble.h"

// Defines all required member variables and functions for a
// single-value field
SO_SFIELD_SOURCE(SFDouble, double, double);

//
// Initializes the class, setting up runtime type info.
//

void
SFDouble::initClass()
{
   // This macro takes the name of the class and the name of the
   // parent class
   SO_SFIELD_INIT_CLASS(SFDouble, SoSField);
}

void
SFDouble::exitClass()
{
   SO_SFIELD_EXIT_CLASS(SFDouble);
}


//
// This reads the value of a double-precision field from a
// file. It returns FALSE if the value could not be read
// successfully.
//

SbBool
SFDouble::readValue(SoInput *in)
{
   // Read a double from the input
   return in->read(value);
}

//
// This writes the value of a double-precision field to a
// file.
//

void
SFDouble::writeValue(SoOutput *out) const
{
   // Write a double
   out->write(value);
}


