/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 4, example 3.
 *
 *  This program initializes the GetVolumeAction class from the
 *  previous examples, reads a scene graph from "volume.iv",
 *  and prints the resulting computed volume to stdout.
 *------------------------------------------------------------*/

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/SoInteraction.h>
#include <Inventor/nodes/SoSeparator.h>

// Header file for new action class
#include "GetVolumeAction.h"

#include <Inventor/helpers/SbFileHelper.h>

int
main(int /*argc*/, char ** /*argv*/)
{
  // Initialize Inventor
  SoInteraction::init();
  
  // Initialize the new action class
  GetVolumeAction::initClass();
  
  // Open the file and read the scene
  SoInput myInput;
  SoSeparator *root;
  SbString filename = SbFileHelper::expandString( "$OIVHOME/examples/source/Inventor/A_GettingStarted/ToolMaker/04.Actions/volume.iv");
  if (! myInput.openFile(filename.toLatin1 ())) {
    fprintf(stderr, "Can't open \"$OIVHOME/examples/source/Inventor/A_GettingStarted/ToolMaker/04.Actions/volume.iv\" for reading\n");
    return 1;
  }
  root = SoDB::readAll(&myInput);
  if (root == NULL) {
    printf("Couldn't read scene from \"$OIVHOME/examples/source/Inventor/A_GettingStarted/ToolMaker/04.Actions/volume.iv\"\n");
    return 2;
  }
  root->ref();
  
  // Compute the volume: apply a GetVolumeAction to the root
  GetVolumeAction va;
  va.apply(root);
  
  root->unref();

  // Print the result
  printf("Total volume = %g\n", va.getVolume());
  
  GetVolumeAction::exitClass();
  SoInteraction::finish();

  return 0;
}


