/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 5, example 1.
 *
 *  Header file for "TemperatureElement" element.
 *------------------------------------------------------------*/

#include <Inventor/elements/SoFloatElement.h>

class TemperatureElement : public SoFloatElement {

   SO_ELEMENT_HEADER(TemperatureElement);

 public:
   // Initializes the TemperatureElement class
   static void    initClass();
   static void    exitClass();

   // Initializes element
   virtual void   init(SoState *state);

   // Sets the current temperature in the state to the given
   // temperature (in degrees Fahrenheit)
   // Note: the 2.0/2.0.1 version of this method had one additional 
   // argument, i.e. set(SoState *state, SoNode *node, float temp);
   
   static void    set(SoState *state, float temp);

   // Returns the current temperature from the state
   static float   get(SoState *state);

   // Returns the default temperature
   static float   getDefault()         { return 98.6f; }

 protected:
   virtual ~TemperatureElement();
};





