/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 6, example 12.
 *
 *  Source file for "ConvertSFShortToSFFloat" field converter
 *  engine.
 *------------------------------------------------------------*/

#include <Inventor/SoDB.h>
#include "ConvertSFShortToSFFloat.h"

SO_ENGINE_SOURCE(ConvertSFShortToSFFloat);

//
// Initializes the ConvertSFShortToSFFloat class.
//

void
ConvertSFShortToSFFloat::initClass()
{
   SO_ENGINE_INIT_CLASS(ConvertSFShortToSFFloat,
                        SoFieldConverter, "FieldConverter");

   // Register this converter's type with the Inventor database
   // to convert from a field (or engine output) of type
   // SoSFShort to a field of type SoSFFloat
   SoDB::addConverter(SoSFShort::getClassTypeId(),
                      SoSFFloat::getClassTypeId(),
                      getClassTypeId());
}

void
ConvertSFShortToSFFloat::exitClass()
{
   SoDB::removeConverter(SoSFShort::getClassTypeId(),SoSFFloat::getClassTypeId());
   SO_ENGINE_EXIT_CLASS(ConvertSFShortToSFFloat);
}

//
// Constructor
//

ConvertSFShortToSFFloat::ConvertSFShortToSFFloat()
{
   // Do standard constructor stuff
   SO_ENGINE_CONSTRUCTOR(ConvertSFShortToSFFloat);

   // Define input field and its default value
   SO_ENGINE_ADD_INPUT(input,  (0));

   // Define the output, specifying its type
   SO_ENGINE_ADD_OUTPUT(output, SoSFFloat);
}

//
// Destructor. Does nothing.
//

ConvertSFShortToSFFloat::~ConvertSFShortToSFFloat()
{
}

//
// This is the evaluation routine.
//

void
ConvertSFShortToSFFloat::evaluate()
{
   // Get the input value as a short, convert it to a float, and
   // output it
   float    value = (float) input.getValue();
   SO_ENGINE_OUTPUT(output, SoSFFloat, setValue(value));
}

//
// This returns the input field for the given type. Since we
// have only one input field, we don't have to check the type.
//

SoField *
ConvertSFShortToSFFloat::getInput(SoType)
{
   return &input;
}

//
// This does the same for the output.
//

SoEngineOutput *
ConvertSFShortToSFFloat::getOutput(SoType)
{
   return &output;
}


