/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 6, example 11.
 *
 *  Header file for "ConvertSFShortToSFFloat" field converter
 *  engine.
 *------------------------------------------------------------*/

#include <Inventor/engines/SoFieldConverter.h>
#include <Inventor/fields/SoSFShort.h>
#include <Inventor/fields/SoSFFloat.h>

class ConvertSFShortToSFFloat : public SoFieldConverter {

 public:

  SO_ENGINE_HEADER(ConvertSFShortToSFFloat);

  // Input:
  SoSFShort        input;

  // Output:
  SoEngineOutput   output;  // (SoSFFloat)

  // Initialization
  static void initClass();
  static void exitClass();

  // Constructor
  ConvertSFShortToSFFloat();

 protected:
  // Destructor
  virtual ~ConvertSFShortToSFFloat();

 private:
  // Evaluation method
  virtual void evaluate();

  // These must be defined for a field converter. They return
  // the input and output connections of the given types. In
  // our case, we have only one input and one output, so we
  // know that those will be the given types.
  virtual SoField *        getInput(SoType type);
  virtual SoEngineOutput * getOutput(SoType type);
};


