/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 6, example 8.
 *
 *  Source file for "FanIn" engine.
 *------------------------------------------------------------*/

#include "FanIn.h"

SO_ENGINE_SOURCE(FanIn);

//
// Initializes the FanIn class.
//

void
FanIn::initClass()
{
   SO_ENGINE_INIT_CLASS(FanIn, SoEngine, "Engine");
}

void
FanIn::exitClass()
{
   SO_ENGINE_EXIT_CLASS(FanIn);
}


//
// Constructor
//

FanIn::FanIn()
{
   // Do standard constructor stuff
   SO_ENGINE_CONSTRUCTOR(FanIn);

   // Define input fields and their default values
   SO_ENGINE_ADD_INPUT(input0,  (0.0));
   SO_ENGINE_ADD_INPUT(input1,  (0.0));
   SO_ENGINE_ADD_INPUT(input2,  (0.0));
   SO_ENGINE_ADD_INPUT(input3,  (0.0));

   // Define the output, specifying its type
   SO_ENGINE_ADD_OUTPUT(output, SoSFFloat);

   // Initialize the pointer that indicates which field changed
   // most recently
   lastChangedField = NULL;
}

//
// Destructor. Does nothing.
//

FanIn::~FanIn()
{
}

//
// This is called when one of our input fields changes. We will
// use it to determine which input value to output.
//

void
FanIn::inputChanged(SoField *whichField)
{
   // Save a pointer to the field that changed; cast it to an
   // SoSFFloat, since that's the only input field type we have
   lastChangedField = (SoSFFloat *) whichField;
}

//
// This is the evaluation routine.
//

void
FanIn::evaluate()
{
   // If evaluate() is called, we must have been notified at
   // some point of a change (including a new connection), so
   // our lastChangedField should never be NULL here. Check it
   // anyway, just for completeness
   if (lastChangedField == NULL) {
      fprintf(stderr, "Uh-oh, there's a NULL lastChangedField"
              "in FanIn::evaluate()!\n");
      return;
   }

   // Output the value from the last changed field
   float   value = lastChangedField->getValue();
   SO_ENGINE_OUTPUT(output, SoSFFloat, setValue(value));
}


