/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Toolmaker,
 *  chapter 6, example 7.
 *
 *  Header file for "FanIn" engine.
 *------------------------------------------------------------*/

#include <Inventor/engines/SoSubEngine.h>
#include <Inventor/fields/SoSFFloat.h>

//
// This engine class takes up to four inputs (input0 through
// input3) and outputs the most recently changed one to the
// output.
//

class FanIn : public SoEngine {

 public:
  
  SO_ENGINE_HEADER(FanIn);
  
  // Inputs:
  SoSFFloat       input0;
  SoSFFloat       input1;
  SoSFFloat       input2;
  SoSFFloat       input3;
  
  // Output:
  SoEngineOutput  output;  // (SoSFFloat)
  
  // Initialization
  static void initClass();
  static void exitClass();
  
  // Constructor
  FanIn();
  
 protected:
  // Destructor
  virtual ~FanIn();
  
 private:
  // This saves a pointer to the field that changed most
  // recently
  SoSFFloat       *lastChangedField;
  
  // This is called when an input value changes - we will use
  // it to figure out which input was changed most recently
  virtual void inputChanged(SoField *whichField);
  
  // Evaluation method
  virtual void evaluate();
};


